/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.client;

import info.aduna.io.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.openrdf.OpenRDFUtil;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.protocol.transaction.TransactionWriter;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.UnsupportedRDFormatException;

public class SesameHTTPClient
extends HTTPClient {
    private String serverURL;

    public void setServerURL(String serverURL) {
        if (serverURL == null) {
            throw new IllegalArgumentException("serverURL must not be null");
        }
        this.serverURL = serverURL;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getRepositoryURL() {
        return this.getQueryURL();
    }

    public void setRepository(String serverURL, String repositoryID) {
        this.setServerURL(serverURL);
        this.setQueryURL(Protocol.getRepositoryLocation((String)serverURL, (String)repositoryID));
    }

    public void setRepository(String repositoryURL) {
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (matcher.matches() && matcher.groupCount() == 1) {
            this.setServerURL(matcher.group(1));
        }
        this.setQueryURL(repositoryURL);
    }

    protected void checkRepositoryURL() {
        if (this.getQueryURL() == null) {
            throw new IllegalStateException("Repository URL has not been set");
        }
    }

    protected void checkServerURL() {
        if (this.serverURL == null) {
            throw new IllegalStateException("Server URL has not been set");
        }
    }

    @Override
    public String getUpdateURL() {
        return Protocol.getStatementsLocation((String)this.getQueryURL());
    }

    public TupleQueryResult getRepositoryList() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getRepositoryList((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getRepositoryList(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkServerURL();
        GetMethod method = new GetMethod(Protocol.getRepositoriesLocation((String)this.serverURL));
        this.setDoAuthentication((HttpMethod)method);
        try {
            this.getTupleQueryResult((HttpMethod)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public String getServerProtocol() throws IOException, RepositoryException, UnauthorizedException {
        this.checkServerURL();
        GetMethod method = new GetMethod(Protocol.getProtocolLocation((String)this.serverURL));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 200) {
                String string = method.getResponseBodyAsString();
                return string;
            }
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (httpCode == 404) {
                throw new RepositoryException("Failed to get server protocol; no such resource on this server");
            }
            ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
            throw new RepositoryException("Failed to get server protocol: " + errInfo);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public long size(Resource ... contexts) throws IOException, RepositoryException, UnauthorizedException {
        GetMethod method;
        block8: {
            this.checkRepositoryURL();
            String[] encodedContexts = Protocol.encodeContexts((Resource[])contexts);
            NameValuePair[] contextParams = new NameValuePair[encodedContexts.length];
            for (int i = 0; i < encodedContexts.length; ++i) {
                contextParams[i] = new NameValuePair("context", encodedContexts[i]);
            }
            method = new GetMethod(Protocol.getSizeLocation((String)this.getQueryURL()));
            this.setDoAuthentication((HttpMethod)method);
            method.setQueryString(contextParams);
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 200) {
                String response = method.getResponseBodyAsString();
                try {
                    long l = Long.parseLong(response);
                    return l;
                }
                catch (NumberFormatException e) {
                    throw new RepositoryException("Server responded with invalid size value: " + response);
                }
            }
            if (httpCode != 401) break block8;
            throw new UnauthorizedException();
        }
        ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
        throw new RepositoryException(errInfo.toString());
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public void deleteRepository(String repositoryID) throws HttpException, IOException, RepositoryException {
        DeleteMethod method = new DeleteMethod(Protocol.getRepositoryLocation((String)this.serverURL, (String)repositoryID));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 204) {
                return;
            }
            if (httpCode == 403) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new UnauthorizedException(errInfo.getErrorMessage());
            }
            ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
            throw new RepositoryException("Failed to delete repository: " + errInfo + " (" + httpCode + ")");
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public TupleQueryResult getNamespaces() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getNamespacesLocation((String)this.getQueryURL()));
        this.setDoAuthentication((HttpMethod)method);
        try {
            this.getTupleQueryResult((HttpMethod)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public String getNamespace(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 200) {
                String string = method.getResponseBodyAsString();
                return string;
            }
            if (httpCode == 404) {
                String string = null;
                return string;
            }
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
            throw new RepositoryException("Failed to get namespace: " + errInfo + " (" + httpCode + ")");
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespacePrefix(String prefix, String name) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        PutMethod method = new PutMethod(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix));
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestEntity((RequestEntity)new StringRequestEntity(name, "text/plain", "UTF-8"));
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!this.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Failed to set namespace: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespacePrefix(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        DeleteMethod method = new DeleteMethod(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!this.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Failed to remove namespace: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNamespaces() throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        DeleteMethod method = new DeleteMethod(Protocol.getNamespacesLocation((String)this.getQueryURL()));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!this.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Failed to clear namespaces: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public TupleQueryResult getContextIDs() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getContextsLocation((String)this.getQueryURL()));
        this.setDoAuthentication((HttpMethod)method);
        try {
            this.getTupleQueryResult((HttpMethod)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public void getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws IOException, RDFHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getStatementsLocation((String)this.getQueryURL()));
        this.setDoAuthentication((HttpMethod)method);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        params.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
        method.setQueryString(params.toArray(new NameValuePair[params.size()]));
        try {
            this.getRDF((HttpMethod)method, handler, true);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTransaction(final Iterable<? extends TransactionOperation> txn) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        PostMethod method = new PostMethod(Protocol.getStatementsLocation((String)this.getQueryURL()));
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestEntity(new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return "application/x-rdftransaction";
            }

            public boolean isRepeatable() {
                return true;
            }

            public void writeRequest(OutputStream out) throws IOException {
                TransactionWriter txnWriter = new TransactionWriter();
                txnWriter.serialize(txn, out);
            }
        });
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!this.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Transaction failed: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        InputStreamRequestEntity entity = new InputStreamRequestEntity(contents, -1L, dataFormat.getDefaultMIMEType());
        this.upload((RequestEntity)entity, baseURI, overwrite, contexts);
    }

    public void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : Charset.forName("UTF-8");
        RequestEntity entity = new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return dataFormat.getDefaultMIMEType() + "; charset=" + charset.name();
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                IOUtil.transfer((Reader)contents, (Writer)writer);
                writer.flush();
            }
        };
        this.upload(entity, baseURI, overwrite, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(RequestEntity reqEntity, String baseURI, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.checkRepositoryURL();
        String uploadURL = Protocol.getStatementsLocation((String)this.getQueryURL());
        Object method = overwrite ? new PutMethod(uploadURL) : new PostMethod(uploadURL);
        this.setDoAuthentication((HttpMethod)method);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        if (baseURI != null && baseURI.trim().length() != 0) {
            String encodedBaseURI = Protocol.encodeValue((Value)new URIImpl(baseURI));
            params.add(new NameValuePair("baseURI", encodedBaseURI));
        }
        method.setQueryString(params.toArray(new NameValuePair[params.size()]));
        method.setRequestEntity(reqEntity);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (httpCode == 415) {
                throw new UnsupportedRDFormatException(method.getResponseBodyAsString());
            }
            if (!this.is2xx(httpCode)) {
                ErrorInfo errInfo = ErrorInfo.parse((String)method.getResponseBodyAsString());
                if (errInfo.getErrorType() == ErrorType.MALFORMED_DATA) {
                    throw new RDFParseException(errInfo.getErrorMessage());
                }
                if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_FILE_FORMAT) {
                    throw new UnsupportedRDFormatException(errInfo.getErrorMessage());
                }
                throw new RepositoryException("Failed to upload data: " + errInfo);
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }
}

