/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.openrdf.http.client.BackgroundGraphResult;
import org.openrdf.http.client.BackgroundTupleResult;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.helpers.ParseErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ValueFactory valueFactory;
    private String queryURL;
    private String updateURL;
    private MultiThreadedHttpConnectionManager manager;
    protected HttpClient httpClient;
    private ExecutorService executor = null;
    private AuthScope authScope;
    private ParserConfig parserConfig = new ParserConfig();
    private TupleQueryResultFormat preferredTQRFormat = TupleQueryResultFormat.BINARY;
    private BooleanQueryResultFormat preferredBQRFormat = BooleanQueryResultFormat.TEXT;
    private RDFFormat preferredRDFFormat = RDFFormat.TURTLE;
    private Map<String, String> additionalHttpHeaders;

    public HTTPClient() {
        this.valueFactory = ValueFactoryImpl.getInstance();
        this.initialize();
    }

    public void shutDown() {
        this.manager.closeIdleConnections(0L);
        this.manager.shutdown();
        this.executor.shutdown();
        this.httpClient = null;
    }

    public void initialize() {
        if (this.httpClient == null) {
            this.executor = Executors.newCachedThreadPool();
            this.manager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            params.setDefaultMaxConnectionsPerHost(20);
            this.manager.setParams(params);
            this.httpClient = new HttpClient((HttpConnectionManager)this.manager);
            HTTPClient.configureProxySettings(this.httpClient);
        }
    }

    protected final HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void setQueryURL(String queryURL) {
        if (queryURL == null) {
            throw new IllegalArgumentException("queryURL must not be null");
        }
        this.queryURL = queryURL;
    }

    public void setUpdateURL(String updateURL) {
        if (updateURL == null) {
            throw new IllegalArgumentException("updateURL must not be null");
        }
        this.updateURL = updateURL;
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.preferredTQRFormat = format;
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.preferredTQRFormat;
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.preferredRDFFormat = format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.preferredRDFFormat;
    }

    public void setPreferredBooleanQueryResultFormat(BooleanQueryResultFormat format) {
        this.preferredBQRFormat = format;
    }

    public BooleanQueryResultFormat getPreferredBooleanQueryResultFormat() {
        return this.preferredBQRFormat;
    }

    public void setUsernameAndPassword(String username, String password) {
        if (username != null && password != null) {
            this.logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)this.queryURL);
            try {
                URL server = new URL(this.getQueryURL());
                this.authScope = new AuthScope(server.getHost(), -1);
                this.httpClient.getState().setCredentials(this.authScope, (Credentials)new UsernamePasswordCredentials(username, password));
                this.httpClient.getParams().setAuthenticationPreemptive(true);
            }
            catch (MalformedURLException e) {
                this.logger.warn("Unable to set username and password for malformed URL {}", (Object)this.queryURL);
            }
        } else {
            this.authScope = null;
            this.httpClient.getState().clearCredentials();
            this.httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders;
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    protected void execute(Runnable command) {
        this.executor.execute(command);
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public TupleQueryResult sendTupleQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        return this.sendTupleQuery(ql, query, null, dataset, includeInferred, 0, bindings);
    }

    public TupleQueryResult sendTupleQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpMethodBase method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        return this.getBackgroundTupleQueryResult((HttpMethod)method);
    }

    public void sendTupleQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, TupleQueryResultHandler handler, Binding ... bindings) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpMethodBase method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        this.getTupleQueryResult((HttpMethod)method, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdate(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpMethod method = this.getUpdateMethod(ql, update, baseURI, dataset, includeInferred, bindings);
        try {
            int httpCode = this.httpClient.executeMethod(method);
            if (!this.is2xx(httpCode)) {
                this.handleHTTPError(httpCode, method);
            }
        }
        finally {
            this.releaseConnection(method);
        }
    }

    public GraphQueryResult sendGraphQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        return this.sendGraphQuery(ql, query, null, dataset, includeInferred, 0, bindings);
    }

    public GraphQueryResult sendGraphQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        try {
            HttpMethodBase method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
            return this.getRDFBackground(method, false);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendGraphQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, RDFHandler handler, Binding ... bindings) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        this.sendGraphQuery(ql, query, null, dataset, includeInferred, 0, handler, bindings);
    }

    public void sendGraphQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, RDFHandler handler, Binding ... bindings) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpMethodBase method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        this.getRDF((HttpMethod)method, handler, false);
    }

    public boolean sendBooleanQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        return this.sendBooleanQuery(ql, query, null, dataset, includeInferred, 0, bindings);
    }

    public boolean sendBooleanQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpMethodBase method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        return this.getBoolean(method);
    }

    protected HttpMethodBase getQueryMethod(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        PostMethod method = new PostMethod(this.getQueryURL());
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        List<NameValuePair> queryParams = this.getQueryMethodParameters(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        if (this.additionalHttpHeaders != null) {
            for (Map.Entry<String, String> additionalHeader : this.additionalHttpHeaders.entrySet()) {
                method.addRequestHeader(additionalHeader.getKey(), additionalHeader.getValue());
            }
        }
        method.setRequestBody(queryParams.toArray(new NameValuePair[queryParams.size()]));
        return method;
    }

    protected HttpMethod getUpdateMethod(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        PostMethod method = new PostMethod(this.getUpdateURL());
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        List<NameValuePair> queryParams = this.getUpdateMethodParameters(ql, update, baseURI, dataset, includeInferred, bindings);
        if (this.additionalHttpHeaders != null) {
            for (Map.Entry<String, String> additionalHeader : this.additionalHttpHeaders.entrySet()) {
                method.addRequestHeader(additionalHeader.getKey(), additionalHeader.getValue());
            }
        }
        method.setRequestBody(queryParams.toArray(new NameValuePair[queryParams.size()]));
        return method;
    }

    protected List<NameValuePair> getQueryMethodParameters(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(bindings.length + 10);
        queryParams.add(new NameValuePair("queryLn", ql.getName()));
        queryParams.add(new NameValuePair("query", query));
        if (baseURI != null) {
            queryParams.add(new NameValuePair("baseURI", baseURI));
        }
        queryParams.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
        if (maxQueryTime > 0) {
            queryParams.add(new NameValuePair("timeout", Integer.toString(maxQueryTime)));
        }
        if (dataset != null) {
            for (URI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add(new NameValuePair("default-graph-uri", String.valueOf(defaultGraphURI)));
            }
            for (URI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add(new NameValuePair("named-graph-uri", String.valueOf(namedGraphURI)));
            }
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue((Value)bindings[i].getValue());
            queryParams.add(new NameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    protected List<NameValuePair> getUpdateMethodParameters(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(bindings.length + 10);
        queryParams.add(new NameValuePair("queryLn", ql.getName()));
        queryParams.add(new NameValuePair("update", update));
        if (baseURI != null) {
            queryParams.add(new NameValuePair("baseURI", baseURI));
        }
        queryParams.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
        if (dataset != null) {
            for (URI graphURI : dataset.getDefaultRemoveGraphs()) {
                queryParams.add(new NameValuePair("remove-graph-uri", String.valueOf(graphURI)));
            }
            if (dataset.getDefaultInsertGraph() != null) {
                queryParams.add(new NameValuePair("insert-graph-uri", String.valueOf(dataset.getDefaultInsertGraph())));
            }
            for (URI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add(new NameValuePair("using-graph-uri", String.valueOf(defaultGraphURI)));
            }
            for (URI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add(new NameValuePair("using-named-graph-uri", String.valueOf(namedGraphURI)));
            }
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue((Value)bindings[i].getValue());
            queryParams.add(new NameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    protected BackgroundTupleResult getBackgroundTupleQueryResult(HttpMethod method) throws RepositoryException, QueryInterruptedException, HttpException, MalformedQueryException, IOException {
        boolean submitted = false;
        try {
            Set tqrFormats = TupleQueryResultParserRegistry.getInstance().getKeys();
            if (tqrFormats.isEmpty()) {
                throw new RepositoryException("No tuple query result parsers have been registered");
            }
            this.sendTupleQueryViaHttp(method, tqrFormats);
            String mimeType = this.getResponseMIMEType(method);
            try {
                TupleQueryResultFormat format = (TupleQueryResultFormat)TupleQueryResultFormat.matchMIMEType((String)mimeType, (Iterable)tqrFormats);
                TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)format, (ValueFactory)this.getValueFactory());
                BackgroundTupleResult tRes = new BackgroundTupleResult(parser, method.getResponseBodyAsStream(), method);
                this.execute(tRes);
                submitted = true;
                BackgroundTupleResult backgroundTupleResult = tRes;
                return backgroundTupleResult;
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
        }
        finally {
            if (!submitted) {
                this.releaseConnection(method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTupleQueryResult(HttpMethod method, TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        try {
            Set tqrFormats = TupleQueryResultParserRegistry.getInstance().getKeys();
            if (tqrFormats.isEmpty()) {
                throw new RepositoryException("No tuple query result parsers have been registered");
            }
            this.sendTupleQueryViaHttp(method, tqrFormats);
            String mimeType = this.getResponseMIMEType(method);
            try {
                TupleQueryResultFormat format = (TupleQueryResultFormat)TupleQueryResultFormat.matchMIMEType((String)mimeType, (Iterable)tqrFormats);
                TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)format, (ValueFactory)this.getValueFactory());
                parser.setQueryResultHandler((QueryResultHandler)handler);
                parser.parseQueryResult(method.getResponseBodyAsStream());
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
            catch (QueryResultParseException e) {
                throw new RepositoryException("Malformed query result from server", (Throwable)e);
            }
            catch (QueryResultHandlerException e) {
                if (e instanceof TupleQueryResultHandlerException) {
                    throw (TupleQueryResultHandlerException)((Object)e);
                }
                throw new TupleQueryResultHandlerException((Throwable)e);
            }
        }
        finally {
            this.releaseConnection(method);
        }
    }

    private void sendTupleQueryViaHttp(HttpMethod method, Set<TupleQueryResultFormat> tqrFormats) throws RepositoryException, HttpException, IOException, QueryInterruptedException, MalformedQueryException {
        for (TupleQueryResultFormat format : tqrFormats) {
            int qValue = 10;
            if (this.preferredTQRFormat != null && !this.preferredTQRFormat.equals((Object)format)) {
                qValue -= 2;
            }
            Iterator i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = (String)i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                method.addRequestHeader("Accept", acceptParam);
            }
        }
        int httpCode = this.httpClient.executeMethod(method);
        if (httpCode == 200) {
            return;
        }
        this.handleHTTPError(httpCode, method);
    }

    protected BackgroundGraphResult getRDFBackground(HttpMethodBase method, boolean requireContext) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        boolean submitted = false;
        try {
            Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
            if (rdfFormats.isEmpty()) {
                throw new RepositoryException("No tuple RDF parsers have been registered");
            }
            this.sendGraphQueryViaHttp((HttpMethod)method, requireContext, rdfFormats);
            String mimeType = this.getResponseMIMEType((HttpMethod)method);
            try {
                RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)mimeType, (Iterable)rdfFormats);
                RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)this.getValueFactory());
                parser.setParserConfig(this.getParserConfig());
                parser.setParseErrorListener((ParseErrorListener)new ParseErrorLogger());
                Charset charset = null;
                if (format.hasCharset()) {
                    String charset_str = method.getResponseCharSet();
                    try {
                        charset = Charset.forName(charset_str);
                    }
                    catch (IllegalCharsetNameException e) {
                        charset = Charset.forName("UTF-8");
                    }
                }
                String baseURI = method.getURI().getURI();
                BackgroundGraphResult gRes = new BackgroundGraphResult(parser, method.getResponseBodyAsStream(), charset, baseURI, (HttpMethod)method);
                this.execute(gRes);
                submitted = true;
                BackgroundGraphResult backgroundGraphResult = gRes;
                return backgroundGraphResult;
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
        }
        finally {
            if (!submitted) {
                this.releaseConnection((HttpMethod)method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getRDF(HttpMethod method, RDFHandler handler, boolean requireContext) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        try {
            Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
            if (rdfFormats.isEmpty()) {
                throw new RepositoryException("No tuple RDF parsers have been registered");
            }
            this.sendGraphQueryViaHttp(method, requireContext, rdfFormats);
            String mimeType = this.getResponseMIMEType(method);
            try {
                RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)mimeType, (Iterable)rdfFormats);
                RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)this.getValueFactory());
                parser.setParserConfig(this.getParserConfig());
                parser.setParseErrorListener((ParseErrorListener)new ParseErrorLogger());
                parser.setRDFHandler(handler);
                parser.parse(method.getResponseBodyAsStream(), method.getURI().getURI());
            }
            catch (UnsupportedRDFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
            catch (RDFParseException e) {
                throw new RepositoryException("Malformed query result from server", (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(method);
        }
    }

    private void sendGraphQueryViaHttp(HttpMethod method, boolean requireContext, Set<RDFFormat> rdfFormats) throws RepositoryException, HttpException, IOException, QueryInterruptedException, MalformedQueryException {
        List acceptParams = RDFFormat.getAcceptParams(rdfFormats, (boolean)requireContext, (RDFFormat)this.preferredRDFFormat);
        for (String acceptParam : acceptParams) {
            method.addRequestHeader("Accept", acceptParam);
        }
        int httpCode = this.httpClient.executeMethod(method);
        if (httpCode == 200) {
            return;
        }
        this.handleHTTPError(httpCode, method);
    }

    /*
     * Exception decompiling
     */
    protected boolean getBoolean(HttpMethodBase method) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendBooleanQueryViaHttp(HttpMethod method, Set<BooleanQueryResultFormat> booleanFormats) throws RepositoryException, HttpException, IOException, QueryInterruptedException, MalformedQueryException {
        for (BooleanQueryResultFormat format : booleanFormats) {
            int qValue = 10;
            if (this.preferredBQRFormat != null && !this.preferredBQRFormat.equals((Object)format)) {
                qValue -= 2;
            }
            Iterator i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = (String)i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                method.addRequestHeader("Accept", acceptParam);
            }
        }
        int httpCode = this.httpClient.executeMethod(method);
        if (httpCode == 200) {
            return;
        }
        this.handleHTTPError(httpCode, method);
    }

    private void handleHTTPError(int httpCode, HttpMethod method) throws MalformedQueryException, QueryInterruptedException, RepositoryException {
        try {
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (httpCode == 503) {
                throw new QueryInterruptedException();
            }
            ErrorInfo errInfo = this.getErrorInfo(method);
            if (errInfo.getErrorType() == ErrorType.MALFORMED_QUERY) {
                throw new MalformedQueryException(errInfo.getErrorMessage());
            }
            if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_QUERY_LANGUAGE) {
                throw new UnsupportedQueryLanguageException(errInfo.getErrorMessage());
            }
            throw new RepositoryException(errInfo.toString());
        }
        catch (Throwable throwable) {
            method.abort();
            throw throwable;
        }
    }

    protected boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    protected String getResponseMIMEType(HttpMethod method) throws IOException {
        Header[] headers;
        for (Header header : headers = method.getResponseHeaders("Content-Type")) {
            HeaderElement[] headerElements;
            for (HeaderElement headerEl : headerElements = header.getElements()) {
                String mimeType = headerEl.getName();
                if (mimeType == null) continue;
                this.logger.debug("reponse MIME type is {}", (Object)mimeType);
                return mimeType;
            }
        }
        return null;
    }

    protected ErrorInfo getErrorInfo(HttpMethod method) throws RepositoryException {
        try {
            ErrorInfo errInfo = ErrorInfo.parse((String)method.getResponseBodyAsString());
            this.logger.warn("Server reports problem: {}", (Object)errInfo.getErrorMessage());
            return errInfo;
        }
        catch (IOException e) {
            this.logger.warn("Unable to retrieve error info from server");
            throw new RepositoryException("Unable to retrieve error info from server", (Throwable)e);
        }
    }

    protected final void setDoAuthentication(HttpMethod method) {
        if (this.authScope != null && this.httpClient.getState().getCredentials(this.authScope) != null) {
            method.setDoAuthentication(true);
        } else {
            method.setDoAuthentication(false);
        }
    }

    protected final void releaseConnection(HttpMethod method) {
        if (Thread.currentThread().isInterrupted()) {
            method.abort();
        }
        method.releaseConnection();
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public long getConnectionTimeout() {
        return this.httpClient.getParams().getConnectionManagerTimeout();
    }

    public void setConnectionTimeout(long timeout) {
        this.httpClient.getParams().setConnectionManagerTimeout(timeout);
    }

    private static void configureProxySettings(HttpClient httpClient) {
        String proxyHostName = System.getProperty("http.proxyHost");
        if (proxyHostName != null && proxyHostName.length() > 0) {
            int proxyPort = 80;
            try {
                proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ProxyHost proxyHost = new ProxyHost(proxyHostName, proxyPort);
            httpClient.getHostConfiguration().setProxyHost(proxyHost);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpClient.getState().setProxyCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                httpClient.getParams().setAuthenticationPreemptive(true);
            }
        }
    }
}

