/*  Command line tool for Sesame
 *  Copyright (C) 2004 CWI
 *
 *  Contact:
 *  CWI
 *  Kruislaan 413
 *  P.O. Box 94079
 *  1090 GB  AMSTERDAM
 *  The Netherlands
 *  http://www.cwi.nl/
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.tools.cmdline;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;

import org.openrdf.sesame.query.GraphQueryResultListener;

/**
 * Simple class to write an RDF graph to an output stream.
 *
 * @author  Jacco.van.Ossenbruggen@cwi.nl 
 * @author  Arjohn Kampman
 * @version $Revision: 1.5 $
 *
 **/
class StreamedGraphWriter implements GraphQueryResultListener  {

/*--------------+
| Variables     |
+--------------*/

	protected RdfDocumentWriter writer = null;

/*--------------+
| Constructors  |
+--------------*/

	public StreamedGraphWriter(OutputStream os) 
		throws IOException
	{
		Writer oswriter = new OutputStreamWriter(os, "utf8");
		writer = new RdfXmlWriter(oswriter);
	}

/*--------------+
| Methods       |
+--------------*/

	public void triple(Resource subj, URI pred, Value obj)  
		throws IOException
	{
		writer.writeStatement(subj, pred, obj);
	}
	
	public void namespace(String prefix, String name)
		throws IOException
	{
		writer.setNamespace(prefix, name);
	}
	
	public void startGraphQueryResult()  
		throws IOException
	{
		writer.startDocument();
	}
	
	public void endGraphQueryResult() 	
		throws IOException
	{
		writer.endDocument();
	}
	
	public void reportError(String msg) {
		System.err.println("ERROR: " + msg);
	}
}
