/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.tools.cmdline;

import java.io.File;
import java.net.URL;

import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.StdOutAdminListener;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;

/**
 * A command line tool to add data to a specific Sesame repository.
 */
public class AddData {

	/**
	 * @param args
	 */
	public static void main(String[] args)
		throws Exception
	{
		if (args.length < 2) {
			_printUsage();
			return;
		}
		
		String systemConfFile = args[0];
		String repositoryID = args[1];
		
		LocalService service = Sesame.getService(new File(systemConfFile));
		service.getSystemConfig().setWorldWriteable(repositoryID, true);
		SesameRepository repository = service.getRepository(repositoryID);
		
		long startTime = System.currentTimeMillis();
		
		for (int i = 2; i < args.length; i++) {
			String dataLoc = args[i];
			System.out.println("Adding file " + dataLoc);
			
			long fileStartTime = System.currentTimeMillis();
			
			AdminListener adminListener = new StdOutAdminListener();
			
			if (dataLoc.toLowerCase().startsWith("http")) {
				URL dataURL = new URL(dataLoc);
				repository.addData(dataURL, dataLoc,
						RDFFormat.RDFXML, true, adminListener);
			}
			else {
				File dataFile = new File(dataLoc);
				repository.addData(dataFile, dataFile.toURI().toString(),
						RDFFormat.RDFXML, true, adminListener);
			}
			
			long fileEndTime = System.currentTimeMillis();
			
			System.out.println("File added in " + (fileEndTime - fileStartTime) + " ms");
		}
		
		long endTime = System.currentTimeMillis();
		
		System.out.println("All files added in " + (endTime - startTime) + " ms");
	}
	
	private static void _printUsage() {
		System.err.println("Usage: java org.openrdf.tools.cmdline.AddData <system-conf-file> <repository-id> {<data-file>|<url>}");
	}

}
