/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.server.soap;

import java.net.URL;
import java.util.Map;
import java.util.Vector;

import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;

public class SoapClient {

//  String SERVER_URL = "http://localhost:8080/soap/servlet/rpcrouter";
  String SERVER_URL = "http://62.213.161.156:8888/soap/servlet/rpcrouter";
  String SERVICE_NAME = "urn:SesameSoap";
/**
 * The only constructor of the SOAP client.
 * @param ServerUrl the URL of the SOAP rpcrouter server
 * @param ServiceName the ID of the SOAP service to use
 */
  public SoapClient(String ServerUrl, String ServiceName) throws java.net.MalformedURLException {
    SERVER_URL = ServerUrl;
    SERVICE_NAME = ServiceName;
    url = new URL(SERVER_URL);
    call.setEncodingStyleURI(encodingStyleURI);
    call.setSOAPMappingRegistry(new SOAPMappingRegistry());
    call.setTargetObjectURI(SERVICE_NAME);
  }

//----------------------------------------------------------------------
// holds the used encoding style
  private static final String encodingStyleURI = Constants.NS_URI_SOAP_ENC;
// holds the url to the Soap server
  private URL url;
// holds the instance used to invoke the Remote interface via SOAP.
// the server keep theck of the current session with the cliean during the
// livetime of that instance (it keeps the cookies thet hold the reference to
// the current session on the server
  private Call call = new Call();

/**
 * the Helper used to invoke the methods of REMOTE Sesame object via SOAP rpc
 */
  private Object invoke(java.lang.reflect.Method method, String[] names, Object[] values)
  {
    // Build the call.
    call.setMethodName(method.getName());

    Vector params = new Vector();
    Class[] paramTypes = method.getParameterTypes();
    for (int i =0; i < names.length; i++)
    {
      Parameter p = new Parameter(names[i], paramTypes[i], SERVICE_NAME, null);
      p.setValue(values[i]);
      params.addElement(p);
    }

    call.setParams(params);

    // Invoke the call.
    Response resp;

    try
    {
      resp = call.invoke(url, "");
    }
    catch (SOAPException e)
    {
      System.err.println("Caught SOAPException (" +
                         e.getFaultCode() + "): " +
                         e.getMessage()+"\n");
      e.printStackTrace(System.err);
      return null;
    }

    // Check the response.
    if (!resp.generatedFault())
    {
      Parameter ret = resp.getReturnValue();
			if (null!=ret) {
				return ret.getValue();
			} else {
				return ret;
			}
    }
    else
    {
      Fault fault = resp.getFault();

      System.err.println("Generated fault: " + fault);
    }
    return null;
  } // invoke()


// the interface of the remote object
/**
 * Retrieve a list of availibe repositories on the server
 * @return an array of repository ID's
 */
  public String[] listRepositories() {
    return (String[])invoke(listRepositories_0, new String[]{}, new Object[]{});
  } //listRepositories()

	public String getRepositoryTitle(String repositoryId) {
		return (String)invoke(getRepositoryTitle_0, new String[]{"repositoryId"}, new Object[]{repositoryId});
	}


  /**
   * Select a repository to work with
   * @param repos repository ID.
   * @return true if successful
   */
	public boolean selectRepository(String repos) {
    Object o = invoke(selectRepository_0, new String[]{"repos"}, new Object[]{repos});
    return ((Boolean)o).booleanValue();
  }

  /**
   * Login to server.
   * @param userID user ID
   * @param pass user password
   * @return true if successful
   */
	public boolean login(String userID, String pass) {
    Object o = invoke(login_0, new String[]{"userID", "pass"}, new Object[]{userID, pass});
    return ((Boolean)o).booleanValue();
  }

  /**
   * Upload a RDF(S) data located on the NET using it's URI into the currently
   * selected repository.
   * @param dataUrl the URL to the RDF(S)data.
   * @param baseURL URI that should be used as namespace for those resources, found in the
   * data, that do not have an explicitly defined one. This parameter can be
   * eiter null or empty string in ehich case the URL to the date will be
   * used as base URL.
   */
  public int addDataFromUrl( String dataUrl, String baseURL) {
    Object o = invoke(addDataFromUrl_0, new String[]{"dataUrl", "baseURL"}, new Object[]{dataUrl, baseURL});
    return ((Integer)o).intValue();
  }
/**
 * Clear the contents of the current repository.
 * @return true if successfull
 */
  public boolean clearRepository() {
    Object o = invoke(clearRepository_0, new String[]{}, new Object[]{});
    return ((Boolean)o).booleanValue();
  }
/**
 * Evaluate an RDQL query over the data held in the current repository
 * @param query the text of the query to evaluate
 * @return a Vector containing the distinct results of the query.
 * NOTE: Each element of that Vector is a String[] contating the URI's of particular
 * distinct result of the evaluated query.
 */
  public Vector evalRdqlQuery(String query) {
    return (Vector)invoke(evalRdqlQuery_0, new String[]{"query"}, new Object[]{query});
  }
/**
 * Evaluate an RQL query over the data held in the current repository
 * @param query the text of the query to evaluate
 * @return a Vector containing the distinct results of the query.
 * NOTE: Each element of that Vector is a String[] contating the URI's of particular
 * distinct result of the evaluated query.
 */
  public Vector evalRqlQuery(String query) {
    return (Vector)invoke(evalRqlQuery_0, new String[]{"query"}, new Object[]{query});
  }
/**
 * Etract the contents of the current repository as RDF.
 * @param ontology flag indicating to include the ontoloy in the result
 * @param instances flag indicating to include instances  in the result
 * @param explicit flag indicating to include only explicit statements in the result
 * @return a string containig the RDF data of the export
 */
  public String extractRDF(boolean ontology, boolean instances, boolean explicit){
    return (String)invoke(extractRDF_0, new String[]{"ontology", "instances", "explicit"}, new Object[]{Boolean.valueOf(ontology), Boolean.valueOf(instances), Boolean.valueOf(explicit)});
  }
/**
 * Retrive a list of the defined classes in the repository
 * @return Vector containig the URI's of the classes
 */
  public Vector getClasses() {
    return (Vector)invoke(getClasses_0, new String[]{}, new Object[]{});
  }
/**
 * Retrive a list of classes to which an Instance belongs
 * @param anInstance Instance to explore
 * @param mostSpecific flag indicating that only the most specific classes to be included in
 * the result
 * @return Vector containig the URI's of the classes
 */
  public Vector getClassesOf(String anInstance, boolean mostSpecific) {
    return (Vector)invoke(getClassesOf_0, new String[]{"anInstance", "mostSpecific"}, new Object[]{anInstance, Boolean.valueOf(mostSpecific)});
  }
/**
 * Retrive a list of URI's of an instances about specific class
 * @param aClass Class to explore
 * @param proper flag indicating thet only the proper instances to be included in
 * the result
 * @return Vector containig the URI's of the instances
 */
  public Vector getInstancesOf(String aClass, boolean proper){
    return (Vector)invoke(getInstancesOf_0, new String[]{"aClass", "proper"}, new Object[]{aClass, Boolean.valueOf(proper)});
  }

/**
 * Retrive a list of the defined properties in the repository
 * @return Vector containig the URI's of the properties
 */
  public Vector getProperties() {
    return (Vector)invoke(getProperties_0, new String[]{}, new Object[]{});
  }

/**
 * Retrive a list of the statemnets from the repository. All the
 * statements that match the provided pattern will be included into teh result
 * @param subj URI of the subject, The null means that the subject does not mather
 * and the statement will be included regarding on the match of its other
 * componets(predicate, object, or is it an explicit one)
 * @param pred URI of the predicate. Tha same rule for the null value is valid
 * @param obj URI of the object. Tha same rule for the null value is valid
 * @param explicitOnly flag indicating that only the explicit statements to be included in the result
 * @param objIsLiteral indicating the the URI of the object is actually an Literal not an
 * Resource URI.
 * @return Vector containig the String[] with URI's of the distinct componets
 * of each statement (subject, predicate and object)
 */
  public Vector getStatements(String subj, String pred,	String obj, boolean explicitOnly, boolean objIsLiteral) {
    return (Vector)invoke(getStatements_0, new String[]{"subj", "pred", "obj", "explicitOnly", "objIsLiteral"}, new Object[]{subj, pred, obj, Boolean.valueOf(explicitOnly), Boolean.valueOf(objIsLiteral)});
  }

  /**
   * Query the repository for particular statement
   * @param subj URI of Subject
   * @param pred URI of Predicate
   * @param obj URI of Object
   * @param explicitOnly flag indicating the the statement is explicit
   * @param objIsLiteral flag indicationg thet object's URI is actuallt a Literal
   */
	public boolean hasStatement(String subj, String pred, String obj, boolean explicitOnly, boolean objIsLiteral) {
    Object o = invoke(hasStatement_0, new String[]{"subj", "pred", "obj", "explicitOnly", "objIsLiteral"}, new Object[]{subj, pred, obj, Boolean.valueOf(explicitOnly), Boolean.valueOf(objIsLiteral)});
    return ((Boolean)o).booleanValue();
  }

  /**
   * Retrieve a list of the subclasses of a class
   * @param resource URI of the class
   * @param direct flag indicating to include only its direct subclasses
   * @return Vector containing the URI's of the subclasses
   */
  public Vector getSubClassesOf(String resource, boolean direct){
    return (Vector)invoke(getSubClassesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, Boolean.valueOf( direct)});
  }
  /**
   * Retrieve a list of the subproperties of a property
   * @param resource URI of the property
   * @param direct flag indicating to include only its direct properties
   * @return Vector containing the URI's of the subproperties
   */
  public Vector getSubPropertiesOf(String resource, boolean direct) {
    return (Vector)invoke(getSubPropertiesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, Boolean.valueOf(direct)});
  }
  /**
   * Retrieve a list of the superclasses of a class
   * @param resource URI of the class
   * @param direct flag indicating to include only its direct superclasses
   * @return Vector containing the URI's of the superclasses
   */
  public Vector getSuperClassesOf(String resource, boolean direct) {
    return (Vector)invoke(getSuperClassesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, Boolean.valueOf(direct)});
  }
  /**
   * Retrieve a list of the superproperties of a property
   * @param resource URI of the property
   * @param direct flag indicating to include only its direct properties
   * @return Vector containing the URI's of the superproperties
   */
  public Vector getSuperPropertiesOf(String resource, boolean direct) {
    return (Vector)invoke(getSuperPropertiesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, Boolean.valueOf(direct)});
  }
  /**
   * Check that a URI is a class
   * @param resource URI to check
   * @return true if not fail
   */
  public boolean isClass(String resource){
    Object o = invoke(isClass_0, new String[]{"resource"}, new Object[]{resource});
    return ((Boolean)o).booleanValue();
  }
  /**
   * Check that a URI is a property
   * @param resource URI to check
   * @return true if not fail
   */
  public boolean isProperty(String resource) {
    Object o = invoke(isProperty_0, new String[]{"resource"}, new Object[]{resource});
    return ((Boolean)o).booleanValue();
  }
  /**
   * Check that a URI is an instance of a class
   * @param anInstance URI of the instance to check
   * @param aClass URI of the class to check for
   * @param proper flag indication that only the proper instances of the class will
   * match the criteria
   * @return true if not fail
   */
  public boolean isInstanceOf(String anInstance, String aClass, boolean proper){
    Object o = invoke(isInstanceOf_0, new String[]{"anInstance", "aClass", "proper"}, new Object[]{anInstance, aClass, Boolean.valueOf(proper)});
    return ((Boolean)o).booleanValue();
  }
  /**
   * Query for subsumtion of two classes
   * @param subClass URI of the subClass
   * @param superClass URI of the superClass
   * @param direct flag indicating to check for direct subsumption
   * @return true if not fail
   */
  public boolean isSubClassOf(String subClass, String superClass, boolean direct) {
    Object o = invoke(isSubClassOf_0, new String[]{"subClass", "superClass", "direct"}, new Object[]{subClass, superClass, Boolean.valueOf(direct)});
    return ((Boolean)o).booleanValue();
  }
  /**
   * Query for subsumtion of two properties
   * @param subProperty URI of the subProperty
   * @param superProperty URI of the superProperty
   * @param direct flag indicating to check for direct subsumption
   * @return true if not fail
   */
  public boolean isSubPropertyOf(String subProperty, String superProperty, boolean direct) {
    Object o = invoke(isSubPropertyOf_0, new String[]{"subProperty", "superProperty","direct"}, new Object[]{subProperty, superProperty, Boolean.valueOf(direct)});
    return ((Boolean)o).booleanValue();
  }
  /**
   * remove statements from the repository
   * @param subjURI URI of the subject
   * @param predURI URI of the predicate
   * @param objURI URI of the object
   * @param bObjectIsLiteral flag indicating that the URI of the object is Literal
   */
  public int removeStatements(String subjURI, String predURI, String objURI, boolean bObjectIsLiteral) {
    Object o = invoke(removeStatements_0, new String[]{"subjURI","predURI","objURI","bObjectIsLiteral"}, new Object[]{subjURI,predURI,objURI,Boolean.valueOf(bObjectIsLiteral)});
    return ((Integer)o).intValue();
  }

  /**
   * Upload RDF(S) data to current repository
   * @param data valid RDF content to upload
   * @param baseURL the namespace of the uploaded content
   */
  public int uploadData(String data, String baseURL) {
    Object o = invoke(uploadData_0, new String[]{"data","baseURL"}, new Object[]{data, baseURL});
    return ((Integer)o).intValue();
  }

	/* ->->-> Versioning And Tracking ->->-> */

	/**
	 * Create a labeled version for a statte of the repository assigning the
	 * necessary mata-information about thet operation.
	 * @param stateUID the update counetr of a particular repository state
	 * @param label the label to be set for this state
	 * NOTE: This method can throw a security exception if the request is made on
	 * behalf of the user with insufficent rights to create versions
	 */
	public void labelState(String stateUID, String label) {
		invoke(labelState_0,new String[]{"stateUID","label"},new Object[]{stateUID,label});
	}

	/**
	 * Create a labeled version of the curent repository state.
	 * NOTE: This method can throw an exception if the request is made on
	 * behalf of an user with insufficent rights to create versions
	 */
	public void labelCurrentState(String label) {
		invoke(labelCurrentState_0,new String[]{"label"},new Object[]{label});
	}

	/**
	 * Restore the repository to previous state removing all statements added
	 * after the value of the update counter and revive all remover ones.
	 * @param stateUID the update counter of a particular repository state
	 * NOTE: This method can throw an exception if the request is made on
	 * behalf of an user with insufficent rights to revert the repository
	 */
	public void revertToState(String stateUID) {
		invoke(revertToState_0,new String[]{"stateUID"},new Object[]{stateUID});
	}

	/**
	 * Sets the repository to given state for further read operations.
	 * @param stateUID the update counter of a particular repository state
	 */
	public void workWithState(String stateUID){
		invoke(workWithState_0,new String[]{"stateUID"},new Object[]{stateUID});
	}

	/**
	 * branch the repository at given state for further operations.
	 * @param stateUID the update counter of a particular repository state
	 * @return the id of the repository
	 */
	public String branchState(String stateUID){
		Object o = invoke(branchState_0,new String[]{"stateUID"},new Object[]{stateUID});
		return (String)o;
	}

	/**
	 * Retrive list of all labeled states of the repository.
	 * @return a list of Versin interfaces for each labeled state of the repository
	 */
	public Vector getVersions(){
		Object o = invoke(getVersions_0,new String[]{},new Object[]{});
		return (Vector)o;
	}

	/**
	 * Retrive list of all Updates of the repository.
	 * @return a list of Updates of the repository
	 */
	public Vector getUpdateIds() {
		Object o = invoke(getUpdateIds_0,new String[]{},new Object[]{});
		Vector v = (Vector) o;
		return v;
	}

	/**
	 * Stop the increment of the update counter. Usefull for a kind of batch updates
	 * or adding a distinct daml coinstructs at once.
	 */
	public void pauseCounterIncrement() {
		invoke(pauseCounterIncrement_0,new String[]{},new Object[]{});
	}

	/**
	 * Coninue with the normal increment of the update counter on each modification
	 * made in the repository.
	 */
	public void continueCounterIncrement() {
		invoke(continueCounterIncrement_0,new String[]{},new Object[]{});
	}

	/**
	 * Check if the update couter ss paused
	 * @return true if the updateCouter is paused, flase otherwise
	 */
	public boolean isPausedCounterIncrement() {
		Object o = invoke(isPausedCounterIncrement_0,new String[]{},new Object[]{});
		return ((Boolean) o).booleanValue();
	}


	public Vector getVersionIds() {
		Object o = invoke(getVersionIds_0,new String[]{},new Object[]{});
		Vector v = (Vector) o;
		return v;
	}

	public Map getMetaInfo(String subj, String pred, String obj) {
		Object o = invoke(getMetaInfo_0,new String[]{"subj","pred","obj"},
											new Object[]{subj,pred,obj});
		Map map = (Map) o;
		return map;
	}

	public Map getVersionMetaInfo(String versionId) {
		Object o = invoke(getVersionMetaInfo_0,new String[]{"versionId"},
											new Object[]{versionId});
		Map map = (Map) o;
		return map;
	}

	public Map getUpdateMetaInfo(String updateId) {
		Object o = invoke(getUpdateMetaInfo_0,new String[]{"updateId"},
											new Object[]{updateId});
		Map map = (Map) o;
		return map;
	}

	/* -<-<-< Versioning And Tracking -<-<-< */


//----------------------------------------------------------------------
// simple reflection used to ease the SOAP invokation
  private static java.lang.reflect.Method addDataFromUrl_0;
  private static java.lang.reflect.Method clearRepository_0;
  private static java.lang.reflect.Method evalRdqlQuery_0;
  private static java.lang.reflect.Method evalRqlQuery_0;
  private static java.lang.reflect.Method extractRDF_0;
  private static java.lang.reflect.Method getClasses_0;
  private static java.lang.reflect.Method getClassesOf_0;
  private static java.lang.reflect.Method getInstancesOf_0;
  private static java.lang.reflect.Method getProperties_0;
  private static java.lang.reflect.Method getStatements_0;
  private static java.lang.reflect.Method hasStatement_0;
  private static java.lang.reflect.Method getSubClassesOf_0;
  private static java.lang.reflect.Method getSubPropertiesOf_0;
  private static java.lang.reflect.Method getSuperClassesOf_0;
  private static java.lang.reflect.Method getSuperPropertiesOf_0;
  private static java.lang.reflect.Method isClass_0;
  private static java.lang.reflect.Method isProperty_0;
  private static java.lang.reflect.Method isInstanceOf_0;
  private static java.lang.reflect.Method isSubClassOf_0;
  private static java.lang.reflect.Method isSubPropertyOf_0;
	private static java.lang.reflect.Method listRepositories_0;
	private static java.lang.reflect.Method getRepositoryTitle_0;
  private static java.lang.reflect.Method login_0;
  private static java.lang.reflect.Method removeStatements_0;
  private static java.lang.reflect.Method selectRepository_0;
  private static java.lang.reflect.Method uploadData_0;

	private static java.lang.reflect.Method labelState_0;
	private static java.lang.reflect.Method	labelCurrentState_0;
	private static java.lang.reflect.Method revertToState_0;
	private static java.lang.reflect.Method workWithState_0;
	private static java.lang.reflect.Method branchState_0;
	private static java.lang.reflect.Method getVersions_0;
	private static java.lang.reflect.Method getUpdateIds_0;
	private static java.lang.reflect.Method pauseCounterIncrement_0;
	private static java.lang.reflect.Method continueCounterIncrement_0;
	private static java.lang.reflect.Method isPausedCounterIncrement_0;

	private static java.lang.reflect.Method getVersionIds_0;
	private static java.lang.reflect.Method getMetaInfo_0;
	private static java.lang.reflect.Method getVersionMetaInfo_0;
	private static java.lang.reflect.Method getUpdateMetaInfo_0;

  static {
    try {
      addDataFromUrl_0 = SoapClient.class.getMethod("addDataFromUrl", new Class[] {String.class, String.class} );
      clearRepository_0 = SoapClient.class.getMethod("clearRepository", new Class[] {} );
      evalRdqlQuery_0 = SoapClient.class.getMethod("evalRdqlQuery", new Class[] {String.class} );
      evalRqlQuery_0 = SoapClient.class.getMethod("evalRqlQuery", new Class[] {String.class} );
      extractRDF_0 = SoapClient.class.getMethod("extractRDF", new Class[] {boolean.class,boolean.class,boolean.class} );
      getClasses_0 = SoapClient.class.getMethod("getClasses", new Class[] {} );
      getClassesOf_0 = SoapClient.class.getMethod("getClassesOf", new Class[] {String.class,boolean.class} );
      getInstancesOf_0 = SoapClient.class.getMethod("getInstancesOf", new Class[] {String.class,boolean.class} );
      getProperties_0 = SoapClient.class.getMethod("getProperties", new Class[] {} );
      getStatements_0 = SoapClient.class.getMethod("getStatements", new Class[] {String.class, String.class, String.class, boolean.class, boolean.class} );
      hasStatement_0 = SoapClient.class.getMethod("hasStatement", new Class[] {String.class, String.class, String.class, boolean.class, boolean.class} );
      getSubClassesOf_0 = SoapClient.class.getMethod("getSubClassesOf", new Class[] {String.class, boolean.class} );
      getSubPropertiesOf_0 = SoapClient.class.getMethod("getSubPropertiesOf", new Class[] {String.class, boolean.class} );
      getSuperClassesOf_0 = SoapClient.class.getMethod("getSuperClassesOf", new Class[] {String.class, boolean.class} );
      getSuperPropertiesOf_0 = SoapClient.class.getMethod("getSuperPropertiesOf", new Class[] {String.class, boolean.class} );
      isClass_0 = SoapClient.class.getMethod("isClass", new Class[] {String.class} );
      isProperty_0 = SoapClient.class.getMethod("isProperty", new Class[] {String.class} );
      isInstanceOf_0 = SoapClient.class.getMethod("isInstanceOf", new Class[] {String.class, String.class, boolean.class} );
      isSubClassOf_0 = SoapClient.class.getMethod("isSubClassOf", new Class[] {String.class, String.class, boolean.class} );
      isSubPropertyOf_0 = SoapClient.class.getMethod("isSubPropertyOf", new Class[] {String.class, String.class, boolean.class} );
      listRepositories_0 = SoapClient.class.getMethod("listRepositories", new Class[] {} );
			getRepositoryTitle_0= SoapClient.class.getMethod("getRepositoryTitle", new Class[] {String.class} );
      login_0 = SoapClient.class.getMethod("login", new Class[] {String.class, String.class} );
      removeStatements_0 = SoapClient.class.getMethod("removeStatements", new Class[] {String.class, String.class, String.class, boolean.class} );
      selectRepository_0 = SoapClient.class.getMethod("selectRepository", new Class[] {String.class} );
      uploadData_0 = SoapClient.class.getMethod("uploadData", new Class[] {String.class, String.class} );

			// versioning and tracking
			labelState_0 = SoapClient.class.getMethod("labelState", new Class[] {String.class, String.class} );
			labelCurrentState_0 = SoapClient.class.getMethod("labelCurrentState", new Class[] {String.class} );
			revertToState_0 = SoapClient.class.getMethod("revertToState", new Class[] {String.class} );
			workWithState_0 = SoapClient.class.getMethod("workWithState", new Class[] {String.class} );
			branchState_0 = SoapClient.class.getMethod("branchState", new Class[] {String.class} );
			getVersions_0 = SoapClient.class.getMethod("getVersions", new Class[] {} );
			getUpdateIds_0 = SoapClient.class.getMethod("getUpdateIds", new Class[] {} );
			pauseCounterIncrement_0 =	SoapClient.class.getMethod("pauseCounterIncrement", new Class[] {} );
			continueCounterIncrement_0 = SoapClient.class.getMethod("continueCounterIncrement", new Class[] {} );
			isPausedCounterIncrement_0 = SoapClient.class.getMethod("isPausedCounterIncrement", new Class[] {} );

			getVersionIds_0 = SoapClient.class.getMethod("getVersionIds", new Class[] {} );

			//meta info
			getMetaInfo_0 = SoapClient.class.getMethod("getMetaInfo", new Class[] {String.class,String.class,String.class} );
			getVersionMetaInfo_0 = SoapClient.class.getMethod("getVersionMetaInfo", new Class[] {String.class} );
			getUpdateMetaInfo_0 = SoapClient.class.getMethod("getUpdateMetaInfo", new Class[] {String.class} );

    } catch (NoSuchMethodException e ) {
      e.printStackTrace();
    }
  } // static initializer
} // SoapClient

