/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.server.rmi;


/*
import java.rmi.RemoteException;
import org.openrdf.sesame.server.*;
import org.openrdf.sesame.constants.*;
import org.openrdf.sesame.local.*;

import org.openrdf.sesame.omm.VersionManagement;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.UserInfo;


import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.model.*;
import org.openrdf.model.impl.*;
import org.openrdf.sesame.sail.*;

import org.openrdf.rio.rdfxml.*;

import java.util.*;
import java.io.*;

*/

import java.io.IOException;

import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.SessionKilled;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.server.SesameServer;

//FIXME: in this class a string is converted to a URI several times. However,
//this string could also contain a bNode identifier. In some of the places,
//it isn't possible to derive whether the string represents a URI or a bNode.



public class ServicesInterfaceImpl implements SesameService {

	private final static String VERSION_SAIL = "org.openrdf.sesame.omm.VersionManagement";

	protected String thisSessionID;

	private SessionKilled sk = null;

	public static void getContext(Object cookie) {
		SessionContext sc = SessionContext.get(cookie);
		SessionContext.setContext(sc);
	}

	private SessionContext getContext() {
		SessionContext sc = null;
		sc = SessionContext.getContext();
		if (sc == null)
			sc = SessionContext.get(thisSessionID);
		if (sc == null)
		{
			sc = new SessionContext();
			SessionContext.put(thisSessionID, sc);
			sk = new SessionKilled(thisSessionID);
			System.out.println("new context created ("+thisSessionID+")");
		}
		SessionContext.setContext(sc);
		return sc;
	}

	public ServicesInterfaceImpl(String theID) {
		System.out.println("ServicesInterfaceImpl constructed");
		thisSessionID = theID;
		getContext();
	}

	/**
	 * Gets a list of all repositories that are accessible by the
	 * currently logged in user. If no user is logged in, all repositories
	 * that are world-accessible are retrieved.
	 *
	 * @return A RepositoryListImpl
	 * @exception IOException If an I/O error occurred while fetching
	 * information about the available repositories.
	 **/
	public RepositoryList getRepositoryList()
		throws IOException {
		return SesameServer.getLocalService().getRepositoryList();
	}

	/**
	 * Gets a SesameRepository object for the specified repository ID.
	 *
	 * @param repositoryID A repository ID.
	 * @exception AccessDeniedException If access to the repository is
	 * denied.
	 * @exception UnknownRepositoryException If the specified
	 * repository ID is unknown.
	 * @exception ConfigurationException If the requested repository
	 * was not configured properly.
	 **/
	public SesameRepository getRepository(String repositoryID)
		throws UnknownRepositoryException,
			   ConfigurationException, IOException 
	{
		return SesameServer.getLocalService().getRepository(repositoryID);
	}

	/**
	 * Log in to a Sesame server.
	 *
	 * @exception AccessDeniedException If the attempt to log in failed.
	 * @exception IOException If an I/O error occurred.
	 * @exception IllegalArgumentException If the supplied username is
	 * not a legal username.
	 **/
	public void login(String username, String password)
		throws AccessDeniedException, IOException {
		SesameServer.getLocalService().login(username, password);
	}

	/**
	 * Log out from a Sesame server.
	 *
	 * @exception IOException If an I/O error occurred.
	 **/
	public void logout()
		throws IOException {
		SesameServer.getLocalService().logout();
	}
}
