package org.openrdf.sesame.server.rmi;

import java.io.IOException;

import org.openrdf.util.log.ThreadLog;
import org.openrdf.util.rmirouting.ChannelIfaceInvocation;

import org.openrdf.model.Value;

import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.server.SesameServer;


/**
 * This is a hepler class where you can start or stop the Sesame RMI server.
 *
 * to start a Seesame, server use:
 *      RMICenter start <system.conf> [#port]
 * where the fisrt argument is a fully specified name of the system config file
 * and the second one is the number of the port where to bind th efactory service
 * for it on the localhost. Plese note that if you specify the RMI settings into
 * the system confing file, you may ommit th eport number. also, if not specified,
 * the default port: 1099 will be used as well.
 *
 * to stop it:
 *      RMICenter stop [#port]
 *
 * @version 1.0
 */
public class RMICenter {

	final static String SYSTEM_CONF_PROP = "system.config";
	final static String RMI_PORT_PROP = "rmi.port";
	final static String RMI_FACTORY_PROP="rmi.factory.class" ;
	final static String REPOSITORY_PROP= "init.repository";
	final static String REPOSITORY_USER= "init.user";
	final static String REPOSITORY_PASS= "init.pass";

	static String sSystemConfFile;
	static String sRepository;
	static String sRMIPort;
	static String sRMIHost;
	static String sSesameUser;
	static String sSesamePass;

	public static void main(String[] args) {
		//----------------
		if (args.length == 0) {
			System.out.println("usage: RMICenter [start <system.conf> [#port] | stop [#port] | test [#port] ]");
			return;
		}

		if (0==args[0].compareToIgnoreCase("start")) {
			Object signal = new Object();
			switch (args.length) {
				case 2:
					sRMIPort = String.valueOf(java.rmi.registry.Registry.REGISTRY_PORT);
					sSystemConfFile = args[1];
					break;
				case 3:
					try {
						sRMIPort = String.valueOf( Integer.parseInt(args[1]) );
						sSystemConfFile = args[2];
					}
					catch (NumberFormatException e) {
						try {
							sRMIPort = String.valueOf( Integer.parseInt(args[2]) );
							sSystemConfFile = args[1];
						} catch (NumberFormatException e2) {
							throw new RuntimeException("At least one of the first two arguments should be a valid port number!");
						}
					}
					break;
			}
			synchronized (signal)	{
				String conf = sSystemConfFile;
				java.io.File ftest = new java.io.File(conf);
				if (!ftest.exists()) {
					throw new RuntimeException("Cannot read from file "+conf+"! It should exist!");
				}

				new RegisteringThread(conf, signal).start();

				try {
					signal.wait();
				}
				catch (InterruptedException e) {}
			}
			return;
		}

		if (0==args[0].compareToIgnoreCase("stop")) {
			ThreadLog.registerThread(null, ThreadLog.ALL);
			try {
				String port = String.valueOf( java.rmi.registry.Registry.REGISTRY_PORT );
				if (args.length > 1) {
					int p2 =0;
					try {
						p2 = Integer.parseInt(args[1]);
					} catch (NumberFormatException e) {
						throw new RuntimeException("The second parameter is not a valid port number !");
					}
					if (p2 >10) {
						port= String.valueOf(p2);
					}
				}
				sRMIPort = port;
				FactoryInterface fi = null;
				try {
				fi = (FactoryInterface)ChannelIfaceInvocation.
						 wrapIt(java.rmi.Naming.lookup("//localhost:"+sRMIPort+"/FactoryInterface"));
				} catch (Throwable t) {
					t.printStackTrace();
					return;
				}
			if (fi != null)
				fi.stopService();
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		}

		if (0==args[0].compareToIgnoreCase("test")) {
			ThreadLog.registerThread(null, ThreadLog.ALL);
			try {
				String port = String.valueOf( java.rmi.registry.Registry.REGISTRY_PORT );
				if (args.length > 1) {
					int p2 =0;
					try {
						p2 = Integer.parseInt(args[1]);
					} catch (NumberFormatException e) {
						throw new RuntimeException("The second parameter is not a valid port number !");
					}
					if (p2 >10)
						port= String.valueOf( p2 );
				}
				sRMIPort = port;

				FactoryInterface fi = null;
				SesameService si = null;
				SesameRepository rep = null;
				if (true) {
					si = Sesame.getService(new java.net.URI("rmi://localhost:"+sRMIPort));
					si.login("admin", "admin");
					rep = si.getRepository("kim");
				} else {
					si = Sesame.getService(new java.io.File(sSystemConfFile));
					ThreadLog.log("repository is being initializing...");
					rep = si.getRepository(RMICenter.sRepository);
					// rep.getSail();
					ThreadLog.log("repository initialized!");
				}
//				RdfSchemaRepository rdfSail = (RdfSchemaRepository)rep.getSail();

				// test schema cache;
//				if (false) {
//					SchemaCache cache = new SchemaCache(rdfSail);
//					String uriEntity = "http://www.ontotext.com/kim/kimo.rdfs#Entity";
//					String uriLocation = "http://www.ontotext.com/kim/kimo.rdfs#Location";
//					String uriCity = "http://www.ontotext.com/kim/kimo.rdfs#City";
//					String uriPerson = "http://www.ontotext.com/kim/kimo.rdfs#Person";
//					if (cache.isSubClassOf(uriLocation, uriEntity))
//						System.out.println("Location is scOf Entity");
//					if (cache.isSubClassOf(uriCity, uriLocation))
//						System.out.println("City is scOf Location");
//					if (!cache.isSubClassOf(uriPerson, uriCity))
//						System.out.println("Person is NOT a scOf City");
//					if (!cache.isSubClassOf(uriCity, uriPerson))
//						System.out.println("City is NOT a scOf Person");
//					return;
//				}
		/*
				if (false) {
					SesameService si2 = fi.getService();
					SesameRepository rep2 = null;
					try {
						rep2 = si2.getRepository(sRepository);
						RdfSchemaRepository srep = (RdfSchemaRepository)rep2.getSail();
					} catch (Throwable tA) {
						tA.printStackTrace();
					}
					return;
				}
		*/
				if (false) {
					// alive test
					String[] str = java.rmi.Naming.list("//localhost:"+java.rmi.registry.Registry.REGISTRY_PORT);
					if (str == null) {
						System.out.println("no services on localhost");
						return;
					}
					for (int i =0; i< str.length; i++) {
						System.out.println(str[i]);
					}
					return;
				}
				// getClasses() TEST
		/*
				if (false) {
					StatementIterator iter = rdfSail.getClasses();
					while (iter.hasNext()) {
						Statement st = iter.next();
						System.out.println(st.toString());
					}
					iter.close();
					return;
				}
		*/

				// evaluate Select SeRQL TEST
				if (false) {
//					String query = "select X from {X} <rdf:type> {<kimo:CountryCapital>}\n "+
//												 " using namespace rdf = <!http://www.w3.org/1999/02/22-rdf-syntax-ns#> ,"+
//												 " rdfs = <!http://www.w3.org/2000/01/rdf-schema#> ,"+
//												 " kimo = <!http://www.ontotext.com/kim/kimo.rdfs#> ";
					String query =
					"select	LA, I, DC "+
					"from "+
					"{TI} <rdf:type> {<kimo:Trusted>}, "+
					"{I} <kimo:generatedBy> {TI}, "+
					"{I} <rdf:type> {<kimo:Entity>}, "+
					"{I} <serql:directType> {DC}, "+
					"{I} <kimo:hasAlias> {} <rdfs:label> {LA} "+
					"using namespace "+
					"rdf = <!http://www.w3.org/1999/02/22-rdf-syntax-ns#> , "+
					"rdfs = <!http://www.w3.org/2000/01/rdf-schema#> , "+
					"kimo = <!http://www.ontotext.com/kim/kimo.rdfs#> ";
					long start = System.currentTimeMillis();
					QueryResultsTable result = rep.performTableQuery(QueryLanguage.SERQL,query);
						System.out.println();
						int i = result.getRowCount();
						int delta = i/25;
						int lastDelta = 0;
						System.out.println("expect "+i+" results");
						for (int ci = 0; ci < result.getRowCount(); ci++ ) {
							for (int cj = 0; cj < result.getColumnCount(); cj++ ) {
//									System.out.println(result.getValue(ci, cj).toString()+" ");
								}
								if (ci /delta > lastDelta) {
									System.out.println(","+ci);
									lastDelta = ci /delta;
								}
							}
							System.out.println("...finished for "+(System.currentTimeMillis() - start));
						return;
				}
				//Namespace Iterator
		/*
				if (false) {
					NamespaceIterator iter = rdfSail.getNamespaces();
					while (iter.hasNext()) {
						iter.next();
						if (iter.getName().indexOf("kimo")!=-1) {
								rdfSail.changeNamespacePrefix(iter.getName(), "kimo");
								rdfSail.changeNamespacePrefix(iter.getName(), iter.getPrefix());
						}
						System.out.println(iter.getName()+" = "+iter.getPrefix());
					}
					iter.close();
					return;
				}
		*/

				//Literal Iterator
		/*
				if (false) {
					LiteralIterator iter = rdfSail.getLiterals("Sofia", null, null);
					while(iter.hasNext()) {
						Value lit = iter.next();
						System.out.println(lit.toString());
					}
					iter.close();
					return;
				}
		*/
				// evaluate with RemoteListener Select SeRQL TEST
				if (true) {
					String query =
//							"select P,Q from {P} <rdf:type> {<kimo:CountryCapital>} \n "+
//												 " ,{P} <rdfs:label> {Q}"+
//												 " using namespace rdf = <!http://www.w3.org/1999/02/22-rdf-syntax-ns#> ,"+
//												 " rdfs = <!http://www.w3.org/2000/01/rdf-schema#> ,"+
//												 " kimo = <!http://www.ontotext.com/kim/kimo.rdfs#> ";
					"select	LA, I, DC "+
					"from "+
					"{TI} <rdf:type> {<kimo:Trusted>}, "+
					"{I} <kimo:generatedBy> {TI}, "+
					"{I} <rdf:type> {<kimo:Entity>}, "+
					"{I} <serql:directType> {DC}, "+
					"{I} <kimo:hasAlias> {} <rdfs:label> {LA} "+
					"using namespace "+
					"rdf = <!http://www.w3.org/1999/02/22-rdf-syntax-ns#> , "+
					"rdfs = <!http://www.w3.org/2000/01/rdf-schema#> , "+
					"kimo = <!http://www.ontotext.com/kim/kimo.rdfs#> ";
					LocalQueryListener wrl = new LocalQueryListener(-1);
					long start = System.currentTimeMillis();
					ThreadLog.log("--- Query started");
					rep.performTableQuery(QueryLanguage.SERQL, query, wrl);
					ThreadLog.log("--- Query ("+wrl.counter+")ended for "+(System.currentTimeMillis() -start));
					wrl = null;
					System.gc();
					return;
				}


			} catch (Exception e) {
				e.printStackTrace();
			}

			return;
		}
		throw new RuntimeException("unknown command\n usage: RMITest [start <system.conf> | stop | test]");
	}
}


class RegisteringThread extends Thread {
	String system_conf_path;
	Object exernalSignal;

	RegisteringThread(String path, Object signal) {
		super();
		exernalSignal = signal;
		system_conf_path = path;
		setDaemon(true);
	}

	public void run() {
		synchronized (exernalSignal) {
			ThreadLog.registerThread(null, ThreadLog.ALL);
			try {
//				SesameStartup.initialize(system_conf_path);
				java.io.File sysFile = new java.io.File(system_conf_path);
				java.io.InputStream in = new java.io.FileInputStream(sysFile);
				SystemConfig sysConfig = SystemConfigFileHandler.readConfiguration(in);
				in.close();
				SesameServer.setSystemConfig(sysConfig);
//				Sesame.getService(new java.io.File(system_conf_path));
				String sFound[] = null;
				try {
					sFound = java.rmi.Naming.list("rmi://localhost:"+RMICenter.sRMIPort+"/FactoryInterface");
				}
				catch (java.rmi.ConnectException e) {
				}

				if (sFound == null || sFound.length == 0) {
					if (RMICenter.sRMIPort != null && RMICenter.sRMIPort.length() > 0 && Integer.parseInt(RMICenter.sRMIPort) > 0) {
						SesameServer.getSystemConfig().setRMIFactory("org.openrdf.sesame.server.rmi.FactoryInterfaceImpl", Integer.parseInt(RMICenter.sRMIPort));
						SesameServer.getSystemConfig().setRMIEnabled(true);
						FactoryInterfaceImpl.bind(new Integer(RMICenter.sRMIPort));
						ThreadLog.log("RMI binded to "+RMICenter.sRMIPort);
					}
				}
				else {
					ThreadLog.log("Probably RMI binded to "+sFound[0]);
				}

				if (RMICenter.sSesameUser != null && RMICenter.sRepository != null) {
					ThreadLog.log("repository "+RMICenter.sRepository+" is being initializing...");
					SesameServer.getLocalService().login(RMICenter.sSesameUser, RMICenter.sSesamePass);
					SesameRepository rep = SesameServer.getLocalService().getRepository(RMICenter.sRepository);
					//rep.getSail();
					ThreadLog.log("repository "+RMICenter.sRepository+" initialized!");
				}
				exernalSignal.notifyAll();
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		} // sunchronized
		ThreadLog.log("RUN ENDED!");
	}
}

class LocalQueryListener implements TableQueryResultListener {
	int max_counter = -1;
	public int counter = 1;
	LocalQueryListener(int num_results) {
		max_counter = num_results;
	}
	public void startTableQueryResult() throws IOException
	{
	}
	public void startTableQueryResult(String[] columnHeaders) throws IOException {
		for (int i = 0; i < columnHeaders.length; i++)
			System.out.print(columnHeaders[i]+" | ");
	}
	public void endTableQueryResult() throws IOException
	{ }
	public void startTuple() throws IOException
	{ }

	public void endTuple() throws IOException {
//		System.out.println();

		counter++;
		return ;
	}

	public void tupleValue(Value value) throws IOException
	{
//		System.out.print(value.toString()+" | ");
	}
	public void error(org.openrdf.sesame.query.QueryErrorType err, String msg) throws IOException {
		System.out.println(msg);
	}
}
