/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.server.rmi;

import org.openrdf.sesame.repository.SesameService;

/**
 * <p>An instance implementing this interface is binded to the local RMI registry and should be used to obtain
 *  remote references to the actual SesameServices located on the server.
 * <p>Because it is wrapped into a <code>ChannelIfaceImpl</code>, the obtained ref should be wrapped locally
 * into a dynamic proxy created via the call to ChannelIfaceInvocation.wrapIt().
 *
 * @see org.openrdf.util.rmirouting.ChannelIfaceInvocation
 * @see org.openrdf.util.rmirouting.ChannelIfaceImpl
 *
 * @author Damyan Ognyanoff
 * @version 1.0
 */
public interface FactoryInterface {

  /**
   * Obtain a service reference from Sesame server.
   * @return a ref to a LocalService at the server.
   */
  public SesameService getService();

  /**
   * To shutdown a running Sesame server.
   */
  public void stopService();
}
