/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.server.http.io;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;


/**
 * Parser for parsing lists of namespaces that are in Sesame's XML format
 * for namespace lists. The parser assumes that the XML is wellformed and
 * correct, and doesn't do any extra verification.
 *
 * @author Arjohn Kampman
 * @author Jeen Broekstra
 * @version $Revision: 1.4.4.2 $
 */
public class NamespaceListParser implements ContentHandler {

/*----------+
| Variables |
+----------*/

	/** NamespaceListener to report the query results to. */
	private NamespaceListener _listener;

/*-------------+
| Constructors |
+-------------*/
	/**
	 * Creates a new NamespaceListParser which reports its query results to the
	 * supplied NamespaceListener.
	 *
	 * @param listener NamespaceListener to report results to.
	 */
	public NamespaceListParser(NamespaceListener listener) {
		_listener = listener;
		
	}

/*--------------------------------------------------+
| Methods from interface org.xml.sax.ContentHandler |
+--------------------------------------------------*/

	public void startElement(String ns, String lName, String qName, Attributes atts) 
	{
		if (qName.equals("namespaceList")) {
			_listener.startNamespaceList();
		} 
		else if (qName.equals("namespace")) {
			String prefix = atts.getValue("prefix");
			String name = atts.getValue("name");

			_listener.namespace(prefix, name);
		}
	}

	public void endElement(String ns, String lName, String qName) {
		if (qName.equals("namespaceList")) {
			_listener.endNamespaceList();
		}
	}

	// Ignore.
	public void ignorableWhitespace(char[] ch, int start, int length) {}

	public void characters(char[] ch, int start, int length) {}

	public void startDocument() {}

	public void endDocument() {}

	public void setDocumentLocator(Locator locator) {}

	public void startPrefixMapping(String prefix, String uri) {}

	public void endPrefixMapping(String prefix) {}

	public void skippedEntity(String name) {}

	public void processingInstruction(String target, String data) {}
}
