/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

import org.openrdf.sesame.server.SesameServer;

public class LogoutServlet extends SesameServlet {

/*--------------------------------------------+
|	Methods                                   |
+--------------------------------------------*/

	protected void _doGet(HttpServletRequest request, HttpServletResponse response)
		throws IOException
	{
		_handleFormURLEncodedRequest(request, response);
	}

	protected void _doPost(HttpServletRequest request, HttpServletResponse response)
		throws IOException
	{
		if (HttpServerUtil.isMultipartFormRequest(request)) {
			_handleMultipartFormRequest(request, response);
		}
		else {
			_handleFormURLEncodedRequest(request, response);
		}
	}

	private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response)
		throws IOException
	{
		// Get request parameters (x-www-form-urlencoded)
		String successPage = HttpServerUtil.getParameter(request, "successPage");

		_handleRequest(request, response, successPage);
	}

	private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response)
		throws IOException
	{
		// Get request parameters (multipart/form-data)
		Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);

		String successPage = HttpServerUtil.getParameter(fileItemMap, "successPage");

		_handleRequest(request, response, successPage);
	}

	private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String successPage)
		throws IOException
	{
		// Log-out action are also logged to login.log:
		SesameServer.setThreadLogFile("login.log");
		_logIP(request);
		ThreadLog.log(">>> logout");

		ThreadLog.trace("successPage = " + successPage);

		// Log out
		SesameServer.getLocalService().logout();
		ThreadLog.trace("User logged out");

		// Send response
		HttpServerUtil.setNoCacheHeaders(response);

		if (successPage != null) {
			// The context path, e.g. '/sesame'
			String contextPath = request.getContextPath();

			// Send redirect
			response.sendRedirect(contextPath + successPage);
		}
		else {
			// send OK message
			response.setStatus(HttpServletResponse.SC_OK);
			response.setContentType("text/plain");
			PrintWriter writer = response.getWriter();
			writer.write("Logged out successfully");
			writer.close();
		}
	}
}
