/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.openrdf.util.http.HttpServerUtil;

import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.VersionManagement;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.sail.SailUtil;
import org.openrdf.sesame.server.SesameServer;

public class CreateVersion extends SesameServlet {

	public CreateVersion() {
		super();
	}

	protected void _doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		if (HttpServerUtil.isMultipartFormRequest(request)) {
			_handleMultipartFormRequest(request, response);
		}
		else {
			_handleFormURLEncodedRequest(request, response);
		}
	}

	private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response)
		throws IOException
	{
		// Get request parameters (x-www-form-urlencoded)
		String uidStr = HttpServerUtil.getParameter(request, "uid");
		String label = HttpServerUtil.getParameter(request, "label");

		_handleRequest(request, response, uidStr, label);
	}

	private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response)
		throws IOException
	{
		// Get request parameters (multipart/form-data)
		Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);

		String uidStr = HttpServerUtil.getParameter(fileItemMap, "uid");
		String label = HttpServerUtil.getParameter(fileItemMap, "label");

		_handleRequest(request, response, uidStr, label);
	}

	private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String uidStr, String label)
		throws IOException
	{
		int uid = Integer.parseInt(uidStr);

		SessionContext sc = SessionContext.getContext();

		try {
			LocalService service = SesameServer.getLocalService();

			_login(service);
			
			LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
			Class vmClass = Class.forName("org.openrdf.sesame.omm.VersionManagement");
			VersionManagement vsail = (VersionManagement)SailUtil.findSailInStack(rep.getSail(), vmClass);
			
			if (vsail != null) {
				if (uid <= 0) {
					vsail.labelCurrentState(label);
				}
				else {
					vsail.labelState(uid, label);
				}
				response.sendRedirect(request.getContextPath() + "/actionFrameset.jsp?repository="+sc.repository);
			}
		}
		catch (ClassNotFoundException e) {
			_sendInternalError("Class VersionManagement not found", e, response);
		}
		catch (ConfigurationException e) {
			_sendBadRequest(e.getMessage(), response);
		}
		catch (AccessDeniedException e) {
			_sendForbidden(e.getMessage(), response);
		}
		catch (UnknownRepositoryException e) {
			_sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, e.getMessage(), response);
		}
	}
}
