/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2003 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms.rules;

/**
 * <p>Title: Custom Inference Rules</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: Ontotext Lab. Sirma AI</p>
 * @author Damyan Ognyanoff
 * @version 1.0
 */
public class TripleTemplate {

	public Component subject = null;
	public Component predicate = null;
	public Component object = null;

	public TripleTemplate(Component subject, Component predicate, Component object) {
		this.subject = subject;
		this.predicate = predicate;
		this.object = object;
	}

	public boolean equals(Object o) {
		if (o instanceof TripleTemplate) {
			TripleTemplate ot = (TripleTemplate)o;

			return subject.equals(ot.subject)
				&& predicate.equals(ot.predicate)
				&& object.equals(ot.object);
		}

		return false;
	}

	public int hashCode() {
		return
			(subject.hashCode() & 0xFF0000) |
			(predicate.hashCode() & 0x00FF00) |
			(object.hashCode() & 0x0000FF);
	}
}
