/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms.model;

import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;

public class IdURI extends URIImpl implements IdResource {

/*----------+
| Variables |
+----------*/

	transient protected RdfSource _source;

    transient protected int _internalId;

/*-------------+
| Constructors |
+-------------*/

    public IdURI(RdfSource source, String uri, int internalId) {
		super(uri);
		_source = source;
		_internalId = internalId;
    }

	public IdURI(RdfSource source, String namespace, String localname, int internalId) {
		super(namespace, localname);
		_source = source;
		_internalId = internalId;
	}

	public IdURI(RdfSource source, URI uri, int internalId) {
		this(source, uri.getNamespace(), uri.getLocalName(), internalId);
	}

/*--------+
| Methods |
+--------*/

    public RdfSource getRdfSource() {
        return _source;
    }

    public int getInternalId() {
    	return _internalId;
    }
    
    public void setInternalId(int internalId) {
    	_internalId = internalId;
    }

	// implements Resource.getSubjectStatements()
    public StatementIterator getSubjectStatements()
		throws GraphException
	{
    	return _source.getStatements(this, null, null);
    }
 
	// implements URI.getPredicateStatements()
    public StatementIterator getPredicateStatements()
		throws GraphException
	{
    	return _source.getStatements(null, this, null);
    }
 
	// implements URI.getObjectStatements()
    public StatementIterator getObjectStatements()
		throws GraphException
	{
    	return _source.getStatements(null, null, this);
    }

	// implements Resource.addProperty(URI, Value)
    public void addProperty(URI property, Value value)
		throws GraphException
	{
		if (_source instanceof RdfRepository) {
			RdfRepository rep = (RdfRepository)_source;
			rep.startTransaction();
			try {
				rep.addStatement(this, property, value);
			}
			catch (SailUpdateException e) {
				throw new GraphException(e);
			}
			finally {
				rep.commitTransaction();
			}
		}
		else {
			throw new GraphException("source not writable");
		}
	}
}
