/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms.model;

import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;

import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;

public class IdLiteral extends LiteralImpl implements IdValue {

/*----------+
| Variables |
+----------*/

	transient protected RdfSource _source;

    transient protected int _internalId;

/*-------------+
| Constructors |
+-------------*/

    public IdLiteral(RdfSource source, String label, int internalId) {
		super(label);
		_source = source;
		_internalId = internalId;
    }

    public IdLiteral(RdfSource source, String label, String lang, int internalId) {
		super(label, lang);
		_source = source;
		_internalId = internalId;
    }

    public IdLiteral(RdfSource source, String label, URI datatype, int internalId) {
		super(label, datatype);
		_source = source;
		_internalId = internalId;
    }
 
/*--------+
| Methods |
+--------*/

    public RdfSource getRdfSource() {
    	return _source;
    }
 
	public int getInternalId() {
		return _internalId;
	}

	public void setInternalId(int internalId) {
		_internalId = internalId;
	}

	// implements Value.getObjectStatements()
	public StatementIterator getObjectStatements()
		throws GraphException
	{
    	return _source.getStatements(null, null, this);
    }
}
