/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms.iterators;

import java.sql.Connection;
import java.sql.SQLException;

import org.openrdf.model.Resource;
import org.openrdf.model.Value;

import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.model.IdBNode;
import org.openrdf.sesame.sailimpl.rdbms.model.IdURI;

/**
 * An implementation of RdbmsValueIterator that iterates rdfs:Resources. It
 * implements getResult() which creates a new Resource. The ResultSet should
 * contain the following columns: id (int), namespace ID (int) and localname
 * (String).
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.9.4.2 $
 */
public class RdbmsResourceIterator
	extends RdbmsValueIterator
	implements ResourceIterator
{

	/**
	 * Constructor.
	 *
	 * @param databaseCon connection with the repository
	 * @param query query to execute
	 */
	public RdbmsResourceIterator(RdfSource source, String[] namespaceNames,
					Connection databaseCon, String query)
	{
		super(source, namespaceNames, databaseCon, query);
	}
		
	/**
	 * Gets the next result out of the ResultSet and returns it as a Resource.
	 *
	 * @return result from ResultSet of type Resource
	 */
	protected Value getResult() {
		try {
			int id = _resultSet.getInt(1);
			int nsId = _resultSet.getInt(2);
			String localname = _resultSet.getString(3);
			if (localname == null) {
				localname = "";
			}

			if (nsId == 0) {
				return new IdBNode(_source, localname, id);
			}
			else {
				return new IdURI(_source, _namespaceNames[nsId], localname, id);
			}
		}
		catch (SQLException e) {
			throw new SailInternalException(e);
		}
	}

	public Resource nextResource() {
		return (Resource)next();
	}
}
