/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms.iterators;

import java.sql.Connection;
import java.sql.SQLException;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

import org.openrdf.sesame.sail.LiteralIterator;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.model.IdLiteral;
import org.openrdf.sesame.sailimpl.rdbms.model.IdURI;

/**
 * An implementation of SQLValueIterator that iterates over literals. It
 * implements getResult() which creates a new Literal. The ResultSet should
 * contain the following columns: id (int), datatypeId (int), datatype
 * namespace ID (int), datatype localname (String), language (String) and
 * label (String).
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.9.4.2 $
 */
public class RdbmsLiteralIterator
	extends RdbmsValueIterator
	implements LiteralIterator
{

	/**
	 * Constructor.
	 *
	 * @param databaseCon connection with the repository
	 * @param query query to execute
	 */
	public RdbmsLiteralIterator(RdfSource source, String[] namespaceNames,
					Connection databaseCon, String query)
	{
		super(source, namespaceNames, databaseCon, query);
	}
	
	/**
	 * Gets the next result from the ResultSet and returns it as a Literal.
	 *
	 * @return result from ResultSet of type Literal
	 */
	protected Value getResult() {
		try {
			int id = _resultSet.getInt(1);
			int dtId = _resultSet.getInt(2);
			String label = _resultSet.getString(6);
			if (label == null) {
				label = "";
			}

			if (dtId != 0) {
				int dtNsId = _resultSet.getInt(3);
				String dtLname = _resultSet.getString(4);
				if (dtLname == null) {
					dtLname = "";
				}

				URI datatype = new IdURI(_source, _namespaceNames[dtNsId], dtLname, dtId);
				return new IdLiteral(_source, label, datatype, id);
			}
			else {
				String lang = _resultSet.getString(5);

				if (lang != null) {
					return new IdLiteral(_source, label, lang, id);
				}
				else {
					return new IdLiteral(_source, label, id);
				}
			}
		}
		catch (SQLException e) {
			throw new SailInternalException(e);
		}
	}

	public Literal nextLiteral() {
		return (Literal)next();
	}
}
