/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms;

/**
 * TableNames defines the names of all tables used by the SQL92 implementation.
 * These names can be refered to directly in a class by implementing this
 * interface.
 *
 * @author Arjohn Kampman
 **/
public interface TableNames {

/*------------------------------------+
| Basic tables                        |
+------------------------------------*/

	/**
	 * Repository metadata.
	 **/
	public static final String REP_INFO_TABLE = "repinfo";

	/**
	 * Namespaces table.
	 **/
	public static final String NAMESPACES_TABLE = "namespaces";

	/**
	 * Resources table.
	 **/
	public static final String RESOURCES_TABLE = "resources";

	/**
	 * Literals table.
	 **/
	public static final String LITERALS_TABLE = "literals";

	/**
	 * Triples table.
	 **/
	public static final String TRIPLES_TABLE = "triples";

/*------------------------------------+
| Tables used during transactions     |
+------------------------------------*/

	/**
	 * rawTriples table, used during a transaction to store the explicitly
	 * added triples in it's raw form (i.e. URIs and literals are not yet
	 * translated to IDs). This table can contain duplicates.
	 **/
	public static final String RAW_TRIPLES_TABLE = "rawtriples";

	/**
	 * addedTriples table, used during a transaction to store the explicitly
	 * added triples.
	 **/
	public static final String ADDED_TRIPLES_TABLE = "addedtriples";

	/**
	 * newTriples table, used during a transaction to filter the duplicates
	 * from the addedTriples table, and also by the RDF-MT inferencer to
	 * infer new statements from the newly added statements.
	 **/
	public static final String NEW_TRIPLES_TABLE = "newtriples";

	/**
	 * removedTriples table, used to store IDs of statements that were
	 * 'removed' during a transaction. The statements are really removed
	 * when the transaction is commited.
	 **/
	public static final String EXPIRED_TRIPLES_TABLE = "expiredtriples";

	/**
	 * expiredValues table, used to store IDs of values that are
	 * potentially no longer used. Note: this table has been replaced by
	 * two new tables (EXPIRED_RESOURCES_TABLE and EXPIRED_LITERALS_TABLE)
	 * in version 5 of the database schema.
	 **/
	public static final String EXPIRED_VALUES_TABLE = "expiredvalues";

	/**
	 * expiredResources table, used to store IDs of resources that are
	 * potentially no longer used.
	 **/
	public static final String EXPIRED_RESOURCES_TABLE = "expiredresources";

	/**
	 * expiredLiterals table, used to store IDs of literals that are
	 * potentially no longer used.
	 **/
	public static final String EXPIRED_LITERALS_TABLE = "expiredliterals";

	/**
	 * groundedTriples table, used to store IDs of statements that are
	 * still 'grounded' after a transaction. Grounded statements are
	 * statements that are either explicit, axioms, or statements that
	 * can be inferred from one of these.
	 **/
	public static final String GROUNDED_TRIPLES_TABLE = "groundedtriples";
	public static final String NEW_GROUNDED_TRIPLES_TABLE = "newgroundedtriples";

/*--------------------------------------+
| Tables used by the RDF MT inferencers |
+--------------------------------------*/

	/**
	 * allNewTriples table, used during a transaction to store all statements
	 * (both explicit and inferred) that have been added. This table is used
	 * to update the auxiliary tables of RdfSchemaRepository.
	 **/
	public static final String ALL_NEW_TRIPLES_TABLE = "allnewtriples";

	/**
	 * inferred table, used during a transaction by the RDF-MT inferencer.
	 **/
	public static final String INFERRED_TABLE = "inferred";

	/**
	 * allInferred table, used during a transaction by the RDF-MT inferencer.
	 **/
	public static final String ALL_INFERRED_TABLE = "allinferred";

	/**
	 * depend table, used to keep track of dependencies between statements.
	 **/
	public static final String DEPEND_TABLE = "depend";

/*------------------------------------+
| Tables from RdfSchemaRepository     |
+------------------------------------*/

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing classes.
	 **/
	public static final String CLASS_TABLE = "class";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing properties.
	 **/
	public static final String PROPERTY_TABLE = "property";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing subClassOf
	 * relations.
	 **/
	public static final String SUBCLASSOF_TABLE = "subclassof";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing direct
	 * subClassOf relations.
	 **/
	public static final String DIRECT_SUBCLASSOF_TABLE = "direct_subclassof";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing subPropertyOf
	 * relations.
	 **/
	public static final String SUBPROPERTYOF_TABLE = "subpropertyof";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing direct
	 * subPropertyOf relations.
	 **/
	public static final String DIRECT_SUBPROPERTYOF_TABLE = "direct_subpropertyof";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing instanceOf
	 * relations.
	 **/
	public static final String INSTANCEOF_TABLE = "instanceof";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing proper
	 * instanceOf relations.
	 **/
	public static final String PROPER_INSTANCEOF_TABLE = "proper_instanceof";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing domain
	 * relations.
	 **/
	public static final String DOMAIN_TABLE = "domain";

	/**
	 * Auxiliary table used by RdfSchemaRepository for storing range
	 * relations.
	 **/
	public static final String RANGE_TABLE = "range";
}
