/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Types;

import org.openrdf.util.StringUtil;

/**
 * Defines SQLServer specific SQL syntax.
 *
 * @author Arjohn Kampman
 * @author Adam Skutt
 **/
public class SQLServer extends RDBMS {

	/**
	 * Initializes SQLServer specific SQL syntax.
	 **/
	public SQLServer() {
		super();

		ID_INT       = "int";
		LOCALNAME    = "nvarchar(255)";
		LANGUAGE     = "varchar(16)";
		LABEL        = "nvarchar(4000)";
		LABEL_TYPE   = Types.VARCHAR;
		LABEL_HASH   = "bigint";
		PREFIX       = "nvarchar(16)";
		NAME         = "nvarchar(4000)";
		NAME_TYPE    = Types.VARCHAR;
		BOOLEAN      = "tinyint";
		BOOLEAN_TYPE = Types.TINYINT;
		TRUE         = "1";
		FALSE        = "0";
		INFOFIELD    = "varchar(255)";
	}

	public void optimizeTable(String tableName)
	 	throws SQLException
	{
		// FIXME: what's the way to do this in SQLServer?
	}

	// Overrides RDBMS.clearTable()
	protected void _clearTable(String tableName)
		throws SQLException
	{
		executeUpdate("TRUNCATE TABLE " + tableName);
	}

	// Overrides RDMBS._renameTable()
	protected void _renameTable(String currentTableName, String newTableName)
		throws SQLException
	{
		// SQL Server does not support support ALTER TABLE ... RENAME TO ...
		// use a stored procedure instead

		// Note: the following is untested code based on examples from the web.
		// It is assumed that it works with SQL Server. If it doesn't, please
		// let us know and we'll try to fix it.
		Connection con = getConnection();
		CallableStatement callSt = con.prepareCall("{call sp_rename(?,?)}");
		callSt.setString(1, currentTableName);
		callSt.setString(2, newTableName);
		callSt.executeUpdate();
	}

	public void renameTableColumn(String tableName, String currentColumnName, String newColumnName, String columnSignature)
		throws SQLException
	{
		// Add a new column with the new name
		executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + newColumnName + " " + columnSignature);

		// Fill the new column with values from the current column
		executeUpdate("UPDATE " + tableName + " SET " + newColumnName + " = " + currentColumnName);

		// Drop the current column
		executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN " + currentColumnName);
	}

	public String escapeString(String s) {
		// Replace single quotes with two single quotes:
		return StringUtil.gsub("'", "''", s);
	}
}
