/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2003 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.rdbms;

/**
 * <p>Title: Custom Inference Rules</p>
 * <p>Description: This interface is an extraction of he basic operations performed
 * from RdbmsSchemaRepository to bothe statement and dependancy inferencers used in it</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: Ontotext Lab. Sirma AI</p>
 * @author Damyan Ognyanoff
 * @version 1.0
 */
import java.sql.SQLException;
import java.util.Map;

public interface InferenceServices extends TableNames {

  /**
   * invoked within sail.initialize(Map configParam).
   * Allows to initialize the custom inferencer(s) with params provided in
   * system.conf
   * @param sail - to which the inferencer is embedded
   * @param configParams - a map holding the sail's confic parameters
   */
  public void initialize(RdfSchemaRepository sail, Map configParams);

  /**
   * invoked to initialize the basic RDFS schema for the repository
   */
  public void initRdfSchema();

  /**
   * the entry point for statement inferencing
   */
  public void doInferencing();

  public void setDependencyInferencer(boolean useDependencyInferencer);

  /**
   * invoked when some statements are being removed
   * @throws SQLException
   */
  public void removeExpiredStatements() throws SQLException;

  /**
   * invoked when some staements are being added so to infer the dependancy information for them
   * @throws SQLException
   */
  public void processNewStatements() throws SQLException;

  /**
   * invoked to mark the currently added statements as axioms
   * @throws SQLException
   */
  public void markAxioms() throws SQLException;

  /**
   * need to handle creation of DEPEND table because some of the rules may
   * need more than 2 columns to store the dependency (rules with three or
   * more triple templates in CustomInferencer)
   * An example of such rule:
   *   a rdf:type owl:TransitiveProperty
   *   x a b
   *   b a c
   * infer:
   *   x a c
   * so the (x a c) triple is dependant from all those
   * @throws SQLException
   */
  public void createDependenciesTable() throws SQLException;

  /**
   * invoked to ensure that thre RDBMS instance is already created within Sail
   */
  public void afterInitialize();
}
