/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.versioning;


import java.util.HashMap;
import java.util.Map;

import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.omm.Version;
import org.openrdf.sesame.server.SesameServer;

public class VersionOMM implements Version {

	public static final String VID_KEY = "VID_KEY";
	public static final String USID_KEY = "USID_KEY";
	public static final String UID_KEY = "UID_KEY";
	public static final String LABEL_KEY = "LABEL_KEY";

	protected HashMap map;

	public VersionOMM(int vid, int usid, int uid, String label) {
		map = new HashMap(8);

		map.put(VID_KEY, new Integer(vid));
		map.put(UID_KEY, new Integer(uid));
		map.put(LABEL_KEY, label);

		UserInfo ui = SesameServer.getSystemConfig().getUserInfo(usid);
		if (ui != null) {
			map.put(USID_KEY, ui.getFullName());
		} else {
			map.put(USID_KEY, "unknown user");
		}
	}

	public long getState() {
		return ((Integer)map.get(UID_KEY)).intValue();
	}

	public Map getMetaInformation() {
		return (Map)map.clone();
	}
}
