/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import org.openrdf.sesame.config.UserInfo;
/**UserImpl.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 * Implementation of the User Interface */
public class UserImpl implements User {

  /** a login and full name of the annonymous user */
  public static final String ANONYMOUS = "ANONYMOUS";

  /** user id */
  private int id;

  /** user login */
  private String login = null;
  /** user's full name */
  private String name = null;

 /** user password */
  private String password = null;
  /** user roles */
  private Set roles = new HashSet(1);
  /** user rules */
  private Set rules = new HashSet(1);

	/** the URI */
	private String uri = null;

  /** the user info for this user */
  private UserInfo userInfo = null;

  /**
   * Construct a new user object.
   * @param id the id of the user
   * @param login the login of the user
   * @param password user's password
   * @param name the name of the user
   * @throws NullParameterException Whenever some of the parameters are null
   */
  public UserImpl(int id, String login, String password, String name) throws NullParameterException {
    if (null==login || null == password || null == name )
      throw new NullParameterException("User's [login], [name] and [password] should not be [null].");
    this.id = id;
    this.password = password;
    this.login = login;
    this.name = name;
  }

  public int getId() { return id; }

  public void setId(int id) {this.id=id; }


  public String getLogin() { return login; }
  public void setLogin(String login) {this.login = login;}

  public String getName() { return name;}
  public void setName(String name) { this.name = name;}


  public String getPassword() {
    return password;
  }

  public void setPassword(String thePassword) throws NullParameterException {
    if ( null == thePassword )
      throw new NullParameterException("User [password] should not be [null].");
    password = thePassword;
  }

  public Set getRoles() {
    return roles;
  }

  public void setRoles(Set roleIDs) throws NullParameterException {
    if ( null == roleIDs )
      throw new NullParameterException("The set of [User roles] should not be [null].");
    roles = roleIDs;
  }

  public Set getRules(){
    return rules;
  }

  public void setRules(Set rules) throws NullParameterException {
    if ( null == rules )
      throw new NullParameterException("The set of [User rules] should not be [null].");
    this.rules = rules;
  }

  public void setUserInfo(UserInfo ui) throws NullParameterException{
    if ( ui == null)
      throw new NullParameterException("User's [User Info] should not be [null].");
    userInfo = ui;
  }

  public UserInfo getUserInfo() {
    return userInfo;
  }

  public ArrayList toSql() {
    ArrayList list = new ArrayList(3);
    StringBuffer query = new StringBuffer();

    //userz 2 rulz
    ArrayList rulz = new ArrayList(rules);
    for ( int ri = 0 ; ri < rulz.size(); ri++ ) {
      query = new StringBuffer();
      Rule rule = (Rule)rulz.get(ri);

      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.USERS_RULES_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(").append(id);
      query.append(",");
      query.append(rule.getId());
      query.append(");");

      list.add(query.toString());
    } // for rulz

    //userz 2 rolez
    ArrayList rolez = new ArrayList(roles);
    for ( int ri = 0 ; ri < rolez.size(); ri++ ) {
      query = new StringBuffer();
      Role role = (Role)rolez.get(ri);

      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.USERS_ROLES_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(").append(id);
      query.append(",");
      query.append(role.getId());
      query.append(");");

      list.add(query.toString());
    } // for rolez

    return list;
  } // toSql()

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getUri() {
		return uri;
	}

} // class UserImpl
