/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.Set;

import org.openrdf.sesame.config.UserInfo;
/**
 * User.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  damyan ognyanoff, borislav popov
 * @version 1.0
 * Interface User. The purpose of this interface is to provide all the basic
 * operations to manage the user information and the assigned roles.
 */
public interface User {

  /**
   * Retrieve the ID of the user
   * @return userID
   */
  int getId();

  /**
   * Set the Id of the user
   * @param id The user's id.
   */
  void setId(int id) ;


  String getLogin();
  void setLogin(String login);

  String getName();
  void setName(String name);

  /**
   * Retrieve the user password
   * @return the password of the user
   */
  String getPassword();

  /**
   * Change the user password.
   * @param password new user password.
   * @throws NullParameterException if the password is null.
   */
  void setPassword(String password) throws NullParameterException;

  /**
   * Retieve a set of the roles assigned to the user.
   */
  Set getRoles();

  /**
   * Assign new Roles to the user. The previous role assignment is overidden.
   * @param roleIDs Set of roleIDs to be assigned to the user
   * @throws NullParameterException if the set is null.
   */
  void setRoles(Set roleIDs) throws NullParameterException;

  /**Retrieve the security rules assigned to the user
   *  @return Set of the rules assigned to the user*/
  Set getRules();

  /**Assign new security rules to the user, as an alternative to assigning roles
   * @param rules set of the rules to be set
   * @throws NullParameterException if the set is null.*/
  void setRules(Set rules) throws NullParameterException;

  /**
   * Sets the user info.
   * @param ui the user info to be set
   * @throws NullParameterException if the parameter is null.
   */
  public void setUserInfo(UserInfo ui) throws NullParameterException;

  /**
   * Gets the user info.
   * @return the user info.
   */
  public UserInfo getUserInfo() ;

  /** Creates update queries over the user_rules users_roles tables.
   * @return A list of update SQL queries, to be used to mirror the objects'
   *  properties from memory to an SQL repository.
   */
  ArrayList toSql();

	void setUri(String uri) ;

	String getUri() ;

} // User interface
