/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.Iterator;

import org.openrdf.model.Statement;

import org.openrdf.sesame.omm.SecurityServices;
import org.openrdf.sesame.sail.StatementIterator;

/**StatementFilterIterator.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 * Filters the Statements according to the access control permissions and the given right.
 */

public class StatementFilterIterator implements StatementIterator {

	ArrayList list = new ArrayList();
	Iterator iter = null;

	public StatementFilterIterator(StatementIterator sti, SecurityServices service, Right right)
		throws NullParameterException
	{
		if ( null == sti ) {
			throw new NullParameterException ("[StatementIterator] should not be [null].");
		}
		if ( null == right ) {
			throw new NullParameterException ("[Right] should not be [null].");
		}
		if ( null == service ) {
			throw new NullParameterException ("[SecurityServices] should not be [null].");
		}

		try {
			while (sti.hasNext()) {
				Statement st = sti.next();
				if (service.isStatementAccessible(st,right)) {
					list.add(st);
				}
			}
			sti.close();

			iter = list.iterator();
		}
		catch (Exception x){
			x.printStackTrace();
			throw new RuntimeException(x.getMessage());
		}
	}

	public boolean hasNext() {
		return iter != null && iter.hasNext();
	}

	public Statement next() {
		return (Statement)iter.next();
	}

	public void close() {
		iter = null;
	}
}
