/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;

/**
 * RuleImpl.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 * Implmentation of the Rule interface.
 */
public class RuleImpl implements Rule {
  /** the id of the rule */
  private int id;

  /** the name of the rule */
  private String name = null;

  /** the description of the rule*/
  private String description = null;

  /** read right */
  private boolean read = false;
  /** add right */
  private boolean add = false;
  /** remove right */
  private boolean remove = false;
  /** admin right */
  private boolean admin = false;
  /** history right */
  private boolean history = false;

	/** the URI */
	private String uri = null;

  /** the restriction of this rule */
  private Restriction restriction = null;

  private static int lastId = 0;

  public RuleImpl(int id, String name, String description) throws NullParameterException {
    if (null == name || null == description )
      throw new NullParameterException("Rule [name] and [description] should not be [null].");
    this.id = id;
    if (id > lastId) lastId = id;
    this.name = name;
    this.description = description;
  }

  public RuleImpl(String name, String description) throws NullParameterException {
    if (null == name || null == description )
      throw new NullParameterException("Rule [name] and [description] should not be [null].");
    this.id = ++lastId;
    this.name = name;
    this.description = description;
  }

  public void setRestriction(Restriction restriction) throws NullParameterException{
    if ( null == restriction )
      throw new NullParameterException("The rule's [restriction] should not be [null]");
    this.restriction = restriction;
  }

  public Restriction getRestriction() {
    return restriction;
  }

  public int getId() {
    return id;
  }

  public void setId(int id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) throws NullParameterException{
    if (null == name)
      throw new NullParameterException("Rule [name] should not be [null].");
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String descr) throws NullParameterException {
    if (null == descr)
      throw new NullParameterException("Rule [description] should not be [null].");
    description = descr;
  }

  public void setReadRight(boolean granted) {
    read = granted;
  }

  public void setAddRight(boolean granted) {
    add = granted;
  }

  public void setRemoveRight(boolean granted) {
    remove = granted;
  }

  public void setHistoryRight(boolean granted) {
      history = granted;
  }

  public void setAdminRight(boolean granted) {
    admin = granted;
  }

  public boolean getReadRight() {
    return read;
  }

  public boolean getAddRight() {
    return add;
  }

  public boolean getRemoveRight() {
    return remove;
  }

  public boolean getHistoryRight() {
    return history;
  }

  public boolean getAdminRight() {
    return admin;
  }

  public ArrayList toSql() {
    ArrayList list = new ArrayList(3);
    StringBuffer query = new StringBuffer();
    query.append(SecuritySail.INSERT);
    query.append(SecuritySail.SECURITY_RULES_TABLE);
    query.append(SecuritySail.VALUES);
    query.append("(").append(id);
    query.append(",'");
    query.append(name);
    query.append("','");
    query.append(description);
    query.append("',");
    query.append(restriction.getId());
    query.append(",");
    query.append(read?1:0);
    query.append(",");
    query.append(add?1:0);
    query.append(",");
    query.append(remove?1:0);
    query.append(",");
    query.append(admin?1:0);
    query.append(",");
    query.append(history?1:0).append(");");

    list.add(query.toString());

    return list;
  } // toSql()

  public void grantRight(Right right) {
    if (right.equals(Right.ADD)) {
		setAddRight(true);
	}
	else if (right.equals(Right.ADMIN)) {
		setAdminRight(true);
	}
	else if (right.equals(Right.HISTORY)) {
		setHistoryRight(true);
	}
	else if (right.equals(Right.READ)) {
		setReadRight(true);
	}
	else if (right.equals(Right.REMOVE)) {
		setRemoveRight(true);
	}
  }

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getUri() {
		return uri;
	}

} // class RuleImpl
