/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;

/**Rule.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 */
public interface Rule {

  /**Get the Id of the rule
   * @return the id of the rule*/
  int getId();

  /**
   * Sets the id of the rule.
   * @param id the id to be set*/
  void setId(int id);

  /**
   * Gets the name of the rule
   * @return name of the rule */
  String getName();

  /**
   * Sets the name of the rule.
   * @param name name of the rule
   * @throws NullParameterException whenever the parameter is null.
   */
   void setName(String name) throws NullParameterException;

   /**
    * Gets rule's description.
    * @return the description of the rule
    */
   String getDescription();

   /**
    * Sets rule's description.
    * @param descr the description to be set
    * @throws NullParameterException whenever the parameter is null.
    */
   void setDescription(String descr) throws NullParameterException;



  /**
   * Set the restriction of the Rule. The restriction defines the set of objects
   * in the repository to which the access right to be applied
   * @param restriction restriction
   * @throws NullParameterException whenecer the parameter is null
   */
  void setRestriction(Restriction restriction)throws NullParameterException;

  /**
   * Restrive the restriction of the rule
   */
  Restriction getRestriction();


  /**
   * Sets the read right.
   * @param granted whether this right to be granted or banned.
   */
  void setReadRight(boolean granted);

  /**
   * Sets the Add right.
   * @param granted whether this right to be granted or banned.
   */
  void setAddRight(boolean granted);

  /**
   * Sets the Remove right.
   * @param granted whether this right to be granted or banned.
   */
  void setRemoveRight(boolean granted);

  /**
   * Sets the History right.
   * @param granted whether this right to be granted or banned.
   */
  void setHistoryRight(boolean granted);

  /**
   * Sets the Admin right.
   * @param granted whether this right to be granted or banned.
   */
  void setAdminRight(boolean granted);

  /**
   * Gets the Read right.
   * @return whether this right is granted or banned.
   */
  boolean getReadRight();

  /**
   * Gets the Add right.
   * @return whether this right is granted or banned.
   */
  boolean getAddRight();

  /**
   * Gets the Remove right.
   * @return whether this right is granted or banned.
   */
  boolean getRemoveRight();

  /**
   * Gets the History right.
   * @return whether this right is granted or banned.
   */
  boolean getHistoryRight();

  /**
   * Gets the Admin right.
   * @return whether this right is granted or banned.
   */
  boolean getAdminRight();

  /** Creates update queries over the rules table.
   * @return A list of update SQL queries, to be used to mirror the objects'
   *  properties from memory to an SQL repository.
   */
  ArrayList toSql();

  /**
   * Grants a right through this rule.
   * @param right the type of the right
   */
  public void grantRight(Right right) ;

	void setUri(String uri) ;

	String getUri() ;

} // Rule interface
