/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/**RoleImpl.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 * Implementation of the Role Interface
 */
public class RoleImpl implements Role {

  /** role id */
  private int id;

  /** role name */
  private String name = null;

  /** role description */
  private String description = null;

  /** set of the rules of this Role*/
  private Set rules = new HashSet();

  /** set of the parent roles */
  private Set parentRoles = new HashSet();

	/** the URI */
	private String uri = null;

 /**the last role id that has been used*/
  static int lastId = 0;

  /**
   * Create a Role given an id, a name and a description.
   * @param id the role id to be set
   * @throws NullParameterException whenever a the id is null
   */
  public RoleImpl(int id, String name, String description ) throws NullParameterException {
    if ( null == name || null == description )
      throw new NullParameterException("Role [name] and [description] should not be [null].");
    this.id = id;
    if ( id > lastId){
      lastId = id;
    }
    this.name = name;
    this.description = description;
  }

  /**
   * Create a Role with the first free id.
   */
  public RoleImpl() {
    this.id = ++lastId;
  }


  public void setDescription(String descr) {
    description=descr;
  }

  public String getDescription(){
    return description;
  }

  public void addRule(Rule rule) throws NullParameterException {
    if ( null == rule )
      throw new NullParameterException("Added [rule] should not be [null].");
    rules.add(rule);
  }

  public void removeRule(Rule rule) throws NullParameterException {
    if ( null == rule )
      throw new NullParameterException("Removed [rule] should not be [null].");
    rules.remove(rule);
  }

  public Set getRules(boolean direct) {
    Set result;
    if (direct) {
      result = rules;
    } else {
      result = new HashSet();
      result.addAll(rules);
      ArrayList parents = new ArrayList(parentRoles);
      for ( int i = 0 ; i< parents.size() ; i++ ) {
        Role pr = (Role)parents.get(i);
        result.addAll(pr.getRules(direct));
      } //for
    } // else
    return result;
  }

  public Set getParentRoles() {
    return parentRoles;
  }

  public void setParentRoles(Set parents) throws NullParameterException {
    if ( null == parents )
      throw new NullParameterException("Set of parent roles [parents] should not be [null].");
    parentRoles = parents;
  }

  public int getId() {
    return id;
  }

  public void setId(int id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public void setName(String roleName) throws NullParameterException {
    if (null == roleName)
      throw new NullParameterException("Role [name] should not be [null].");
  }

  public ArrayList toSql() {
    ArrayList list = new ArrayList(3);
    StringBuffer query = new StringBuffer();
    query.append(SecuritySail.INSERT);
    query.append(SecuritySail.ROLES_TABLE);
    query.append(SecuritySail.VALUES);
    query.append("(").append(id);
    query.append(",'");
    query.append(name);
    query.append("','");
    query.append(description).append("');");

    list.add(query.toString());

    //roles 2 rulz
    ArrayList rulz = new ArrayList(rules);
    for ( int ri = 0 ; ri < rulz.size(); ri++ ) {
      query = new StringBuffer();
      Rule rule = (Rule)rulz.get(ri);

      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.ROLES_RULES_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(").append(id);
      query.append(",");
      query.append(rule.getId());
      query.append(");");

      list.add(query.toString());
    } // for rulz

    //roles 2 parents
    ArrayList parentz = new ArrayList(parentRoles);
    for ( int pi = 0 ; pi < parentz.size(); pi++ ) {
      query = new StringBuffer();
      Role role = (Role)parentz.get(pi);

      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.ROLES_HIERARCHY_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(").append(id);
      query.append(",");
      query.append(role.getId());
      query.append(");");

      list.add(query.toString());
    } // for parent rolez

    return list;
  }


  /** Retrieve the set of rules defined for the given set of roles.
    * @param roles
    * @param direct direct or transtive closure
    * @return the set of rules defined for the given set of roles.
    */
  public static Set getRules(Set roles, boolean direct) {
    ArrayList list = new ArrayList(roles);
    Set result = new HashSet();
    for (int i=0; i< list.size(); i++){
      Role role = (Role)list.get(i);
      result.addAll(role.getRules(direct));
    }
    return result;
  }

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getUri() {
		return uri;
	}

} // class RoleImpl
