/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.Set;
/**
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  damyan ognyanoff, borislav popov
 * @version 1.0
 * Interface Role. The purpose of that interface is to provide all the basic
 * operations to manage the Role and its sequrity rules. There are
 * two kinds of rules for a paricular Role:
 *  - rules inherited from its parents
 *  - own rules
 */
public interface Role {

  /**
   * Retireve the Id of that role
   * @return the role's Id
   */
   int getId();

   /**
    * Sets roles id.
    * @param id the id to be set
    */
   void setId(int id);

   /**
    * Sets role description
    * @param descr the description of the role
    */
   public void setDescription(String descr);

   /**
    * Gets the role description
    * @return the role description
    */
   public String getDescription();


  /**
   * Retireve the Name of that role
   * @return the role's Name
   */
  String getName();

  /**
   * Change the role Name
   * @param roleName New name for the role
   * @throws NullParameterException whenever the parameter is null
   */
  void setName(String roleName) throws NullParameterException;


  /**
   * Add a new security rule for the Role
   * @param rule the interface to a new rule
   * @throws NullParameterException whenever the parameter is null
   */
  void addRule(Rule rule) throws NullParameterException;

  /**
   * Remove a security Rule from the role
   * @param rule rule to remove
   * @throws NullParameterException whenever the parameter is null
   */
  void removeRule(Rule rule) throws NullParameterException;

  /**
   * Retrive a list of rules in the Role. The items in the list are Rule intrfaces.
   * See the Rights class for all supported access Rights
   * @param direct depending on this the result will contain either the own rules of this role,
   * either all inherited rules.
   * @return set of, either the own rules of this role,
   * either all inherited rules, depending on the parameter.
   */
  Set getRules(boolean direct);

  /**
   * Retrieve a list of roleIDs of the parent roles.
   * @return set of roleIDs
   */
  Set getParentRoles();

  /**
   *
   * @param parents set of the ids of the roles to be inherited
   * @throws NullParameterException whenever the parameter is null
   */
  void setParentRoles(Set parents) throws NullParameterException;

  /** Creates update queries over the roles, roles_hierarchy and roles_rules tables.
   * @return A list of update SQL queries, to be used to mirror the objects'
   *  properties from memory to an SQL repository.
   */
  ArrayList toSql();

	void setUri(String uri) ;

	String getUri() ;


} // Role interface
