/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import org.openrdf.util.Enumeration;

/**
 * This class lists all supported access right for the respository.
 * It can be extended with any suitable additions, if necessary.
 *
 * <p>Title: Knowledge Control System</p>
 * <p>Company: OntoText Lab. Sirma AI.</p>
 * @author damyan ognyanoff, borislav popov
 * @version 1.0
 */
public final class Right extends Enumeration {

/*-------------+
| Static stuff |
+-------------*/

	/** permissions to read parts of the repository */
	public static final Right READ = new Right("READ");

	/** permissions to add new items in the repository */
	public static final Right ADD = new Right("ADD");

	/** permissions to remove items from the repository */
	public static final Right REMOVE = new Right("REMOVE");

	/** permissions to view and manage the security information in the repository */
	public static final Right ADMIN = new Right("ADMIN");

	/** permissions to manage the history in the repository */
	public static final Right HISTORY = new Right("HISTORY");

	/**
	 * A Right array containing all possible values.
	 **/
	static private Right[] _values = new Right[] { READ, ADD, REMOVE, ADMIN, HISTORY };

	/**
	 * Returns a Right constant for the specified value.
	 *
	 * @param value The String-representation of a Right constant.
	 * @return A Right object, or <tt>null</tt> if the specified value
	 * could not be resolved to a Right object.
	 **/
	public static Right forValue(String value) {
		return (Right)_forValue(_values, value);
	}

/*--------------+
| Constructors  |
+--------------*/

	private Right(String text) {
		super(text);
	}
}
