/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.openrdf.model.Resource;

/**ResourceRestriction.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 * Base class for Classes/Instances Restrictions
 */
public class ResourceRestriction extends Restriction {
  /** the set of resources that form this restriction*/
  Set resources = new HashSet();

  /**
   * Create a Resource Restriction.
   * @param id id of the restriction.
   * @param name name of the restriction.
   * @param descr description of the restriction.
   */
  public ResourceRestriction(int id, int type,String name, String descr) {
    super(id,type,name, descr);
  }

  /**retrieve the resources forming the restriction
   * @return set of the resources */
  public Set getResources(){
    return resources;
  }

  /**
   * Sets the resources that form this restriction.
   * @param resources the resources to be set to this restriction
   * @throws NullParameterException if the parameter is null
   */
  public void setResources(Set resources) throws NullParameterException {
    if ( null==resources )
      throw new NullParameterException("[resources] should not be [null].");
    this.resources = resources;
  }


  public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException,SecurityException {
    if (idByRes == null )
      throw new NullParameterException("[ids by resources] map should not be [null].");
    if (idByLiteral == null )
      throw new NullParameterException("[ids by literals] map should not be [null].");

    // update query for the res_prop_restrs table
    ArrayList list = super.toSql(idByLiteral,idByRes);
    ArrayList resourcez = new ArrayList(resources);

    for ( int ri = 0 ; ri < resourcez.size() ; ri++) {
      Resource res =null;
      res = (Resource)resourcez.get(ri);

      Integer i = (Integer) idByRes.get(res);
      if ( i == null ) {
        // it might be a literal
        i = (Integer) idByLiteral.get(res);
        if ( i == null )
          throw new SecurityException("Id not found for resource/literal : \n"+res);
      }
      int rid = i.intValue();

      StringBuffer query = new StringBuffer();
      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.RES_PROP_RESTRS_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(").append(id);
      query.append(",");
      query.append(rid).append(");");

      list.add(query.toString());

    } // for resourcez

    return list;
  }// toSql()


}
