/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.Iterator;

import org.openrdf.model.Resource;
import org.openrdf.model.Value;

import org.openrdf.sesame.omm.SecurityServices;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

/**ResourceFilterIterator.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author  borislav popov
 * @version 1.0
 * Filters the resources from a resource iterator,
 * according to the classes,instances,repository and schema restrictions.
 */

public class ResourceFilterIterator implements ResourceIterator {

  SecurityServices service = null;
  ArrayList list = new ArrayList();
  Iterator iter = null;

  public ResourceFilterIterator(ResourceIterator ri, SecurityServices serv)
  throws NullParameterException, QueryEvaluationException {
    if ( null == ri )
      throw new NullParameterException ("[ResourceIterator] should not be [null].");
    if ( null == serv )
      throw new NullParameterException ("[SecurityServices] should not be [null].");

    service = serv;
    while (ri.hasNext()) {
      Resource res = ri.nextResource();
      if (service.isResourceAccessible(res))
        list.add(res);
    }
    iter = list.iterator();
  }


  public ResourceFilterIterator(ValueIterator vi, SecurityServices serv)
  throws NullParameterException, QueryEvaluationException {
    if ( null == vi )
      throw new NullParameterException ("[ValueIterator] should not be [null].");
    if ( null == serv )
      throw new NullParameterException ("[SecurityServices] should not be [null].");

    service = serv;
    while (vi.hasNext()) {

      Value val = vi.next();
      if ( val instanceof Resource ) {
        Resource res = (Resource) val;
        if (service.isResourceAccessible(res))
          list.add(res);
      } else {
        list.add(val);
      }
    }
    iter = list.iterator();
  }

  public ResourceFilterIterator() {
    iter = list.iterator();
  }

  public Resource nextResource() {
    return (Resource) iter.next();
  }

  public boolean hasNext() {
    return iter.hasNext();
  }

  public Value next() {
    return (Value)iter.next();
  }

  public void close() {}
}
