/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
/**QueryRestriction.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author damyan ognyanoff, borislav popov
 * @version 1.0
 */
public class QueryRestriction extends Restriction
{
  /** The set of queries that form this restriction */
  Set queries = new HashSet();

  /**
   * Create a Pattern Restriction.
   * @param id id of the restriction.
   * @param name name of the restriction.
   * @param descr description of the restriction.
   * @return the created restriction
   */
  QueryRestriction(int id, String name, String descr) {
    super(id,QUERY,name,descr);
  }

  /**
   * Adds a query to this restriction.
   * @param strQuery the query to be added.
   */
  public void addQuery(String strQuery) {
    queries.add(strQuery);
  }

  /**
   * Gets the set of queries that form this restriction.
   * @return the set of queries that form this restriction
   */
  public Set getQueries() {
    return queries;
  }

  public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException,SecurityException {
    if (idByRes == null )
      throw new NullParameterException("[ids by resources] map should not be [null].");
    if (idByLiteral == null )
      throw new NullParameterException("[ids by literals] map should not be [null].");


    ArrayList list = super.toSql(idByLiteral,idByRes);

    ArrayList quers = new ArrayList(queries);

    for ( int i = 0 ; i < quers.size() ; i++ ) {
      String rstQuery = quers.get(i).toString();
      StringBuffer query = new StringBuffer();
      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.QUERY_RESTRS_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(").append(id);
      query.append(",'");
      query.append(rstQuery).append("');");

      list.add(query.toString());

    } // for queris

    return list;
  }// toSql()

} // QueryRestriction
