/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.openrdf.model.Literal;
/**PatternRestriction.java
 * <p>Title: Knowledge Control System</p>
 * <p> </p>
 * <p> </p>
 * <p>Company: OntoText Lab. Sirma AI. </p>
 * @author damyan ognyanoff, borislav popov
 * @version 1.0
 * Accomodates a Pattern Restriction.
 */
public class PatternRestriction extends Restriction
{
  /* SUBJECT PREDICATE OBJECT types as indexed in the db */

  /** subject restriction */
  public final static int SPO_SUBJECT = 0;
  public final static int SPO_PREDICATE = 1;
  public final static int SPO_OBJECT = 2;
  public final static int SPO_OBJECT_LITERAL = 3;

  /**Set of subject restrictions */
  Set subjectRestrictions = new HashSet();

  /**Set of predicate restrictions */
  Set predicateRestrictions = new HashSet();

  /**Set of object restrictions */
  Set objectRestrictions = new HashSet();

  /**
   * Create a Pattern Restriction.
   * @param id id of the restriction.
   * @param name name of the restriction.
   * @param description description of the restriction.
   */
  public PatternRestriction(int id,String name,String description) {
    super(id,PATTERN,name,description);
  }

  /**
   * Adds a subject restriction.
   * @param subjRestr subject restriction to be added
   */
  public void addSubjectRestriction(ResourceRestriction subjRestr) {
    if (subjRestr.type == CLASSES || subjRestr.type == INSTANCES ||
    subjRestr.type == CLASSES_OVER_SCHEMA){
      subjectRestrictions.add(subjRestr);
    }
  }

  /**
   * Adds a predicate restriction.
   * @param propRestr predicate restriction to be added
   */
  public void addPredicateRestriction(PropertiesRestriction propRestr)  {
    predicateRestrictions.add(propRestr);
  }

  /**
   * Adds an object restriction.
   * @param objRestr the object restriction to be set
   */
  public void addObjectRestriction(ResourceRestriction objRestr)
  {
    if (objRestr.type == CLASSES || objRestr.type == INSTANCES
      || objRestr.type == CLASSES_OVER_SCHEMA)
    {
     objectRestrictions.add(objRestr);
    }
  }

  /**
   * Adds an object restriction.
   * @param literal the literal to be added as object restriction
   * @throws NullParameterException if the parameter is null.
   */
  public void addObjectRestriction(Literal literal) throws NullParameterException  {
    objectRestrictions.add(literal);
  }

  /**
   * Gets the set of subject restrictions.
   * @return the set of subject restrictions
   */
  public Set getSubjectRestrictions() {
    return subjectRestrictions;
  }

  /**
   * Gets the set of predicate restrictions
   * @return the set of predicate restrictions
   */
  public Set getPredicateRestrictions() {
    return predicateRestrictions;
  }

  /**
   * Gets the set of object restrictions.
   * @return the set of object restrictions
   */
  public Set getObjectRestrictions() {
    return objectRestrictions;
  }


  /**
   *
   * @param idByLiteral ids by literals map
   * @param idByRes ids by resources map
   */
  public ArrayList toSql(Map idByLiteral, Map idByRes)
    throws NullParameterException,SecurityException {
    if (idByRes == null )
      throw new NullParameterException("[ids by resources] map should not be [null].");
    if (idByLiteral == null )
      throw new NullParameterException("[ids by resources] map should not be [null].");

    // update query for the pattern_restrs table
    ArrayList list = super.toSql(idByLiteral,idByRes);
    StringBuffer query = null;

    ArrayList subjectz = new ArrayList(subjectRestrictions);
    for ( int si = 0 ; si < subjectz.size() ; si++) {
      ResourceRestriction r = (ResourceRestriction) subjectz.get(si);
      query = new StringBuffer();
      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.PATTERN_RESTRS_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(");
      query.append(id);
      query.append(",");
      query.append(r.getId());
      query.append(",");
      query.append(SPO_SUBJECT);
      query.append(");");

      list.add(query.toString());
    } // for subjectz

    ArrayList predz = new ArrayList(predicateRestrictions);
    for ( int pi = 0 ; pi < predz.size() ; pi++) {
      PropertiesRestriction r = (PropertiesRestriction) predz.get(pi);
      query = new StringBuffer();
      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.PATTERN_RESTRS_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(");
      query.append(id);
      query.append(",");
      query.append(r.getId());
      query.append(",");
      query.append(SPO_PREDICATE);
      query.append(");");

      list.add(query.toString());

    } // for predicatz

    ArrayList objectz = new ArrayList(objectRestrictions);
    for ( int oi = 0 ; oi < objectz.size() ; oi++) {
      ResourceRestriction r = (ResourceRestriction) objectz.get(oi);
      query = new StringBuffer();
      query.append(SecuritySail.INSERT);
      query.append(SecuritySail.PATTERN_RESTRS_TABLE);
      query.append(SecuritySail.VALUES);
      query.append("(");
      query.append(id);
      query.append(",");
      query.append(r.getId());
      query.append(",");
      query.append(SPO_OBJECT);
      query.append(");");

      list.add(query.toString());
    } // for objectz

    return list;
  }// toSql()

} //PatternRestriction
