/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.nativerdf.model;

import org.openrdf.model.Value;

import org.openrdf.sesame.sailimpl.nativerdf.NativeRdfRepository;
import org.openrdf.sesame.sailimpl.nativerdf.ValueStoreRevision;

public interface NativeValue extends Value {

	/**
	 * Returns the NativeRdfRepository that contains this NativeValue. IDs are
	 * only unique within a single repository, but an application could use
	 * several repositories at the same time, passing NativeValue objects
	 * generated by one Sail to another Sail. In such situations, the ID of the
	 * first Sail cannot be used by the second Sail. Hence, the
	 * NativeRdfRepository should verify that it is the 'owner' of a value before
	 * using the recorded internal ID.
	 */
	public NativeRdfRepository getRepository();

	/**
	 * Sets the ID that is used for this value in a specific revision of the
	 * value store.
	 */
	public void setInternalId(int id, ValueStoreRevision revision);

	/**
	 * Gets the ID that is used in the native RDF repository for this Value.
	 * 
	 * @return The value's ID, or <tt>0</tt> if not yet set.
	 */
	public int getInternalId();

	/**
	 * Gets the revision of the value store that created this value. The value's
	 * internal ID is only valid when it's value store revision is equal to the
	 * value store's current revision.
	 *
	 * @return The revision of the value store that created this value, or
	 * <tt>null</tt> if the internal ID has not yet been set.
	 */
	public ValueStoreRevision getValueStoreRevision();
}
