/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.nativerdf.model;

import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;

import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.nativerdf.NativeRdfRepository;
import org.openrdf.sesame.sailimpl.nativerdf.ValueStoreRevision;

public class NativeLiteral extends LiteralImpl implements NativeValue {

	/*----------+
	 | Variables |
	 +----------*/

	transient private NativeRdfRepository _repository;

	transient private ValueStoreRevision _revision;

	transient private int _id;

	/*-------------+
	 | Constructors |
	 +-------------*/

	public NativeLiteral(NativeRdfRepository repository, String label) {
		super(label);
		_repository = repository;
	}

	public NativeLiteral(NativeRdfRepository repository, String label, String lang) {
		super(label, lang);
		_repository = repository;
	}

	public NativeLiteral(NativeRdfRepository repository, String label, URI datatype) {
		super(label, datatype);
		_repository = repository;
	}

	/*--------+
	 | Methods |
	 +--------*/

	public NativeRdfRepository getRepository() {
		return _repository;
	}

	public void setInternalId(int id, ValueStoreRevision revision) {
		_id = id;
		_revision = revision;
	}

	public int getInternalId() {
		return _id;
	}

	public ValueStoreRevision getValueStoreRevision() {
		return _revision;
	}

	// Implements Value.getObjectStatements()
	public StatementIterator getObjectStatements()
		throws GraphException
	{
		if (_repository == null) {
			throw new GraphException("no backing store associated");
		}

		return _repository.getStatements(null, null, this);
	}
}
