package org.openrdf.sesame.sailimpl.nativerdf;

import org.openrdf.sesame.sailimpl.nativerdf.model.NativeValue;

/**
 * A {@link ValueStore ValueStore} revision for {@link NativeValue NativeValue}
 * objects. For a cached value ID of a NativeValue to be valid, the revision
 * object needs to be equal to the concerning ValueStore's revision object. The
 * ValueStore's revision object is changed whenever values are removed from it
 * or IDs are changed.
 */
public class ValueStoreRevision {

	/*-----------*
	 * Variables *
	 *-----------*/

	private ValueStore _valueStore;

	/*--------------*
	 * Constructors *
	 *--------------*/

	public ValueStoreRevision(ValueStore valueStore) {
		_valueStore = valueStore;
	}

	/*---------*
	 * Methods *
	 *---------*/

	public ValueStore getValueStore() {
		return _valueStore;
	}
}
