/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.nativerdf;

/**
 * Object that represents a Namespace.
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.3.4.2 $
 */
class Namespace {

/*----------+
| Variables |
+----------*/

	/** Internal ID of the namespace. **/
	private int _id;

	/** Prefix of the namespace*/
	private String _prefix;

	/** Name of the namespace*/
	private String _name;

	private boolean _export = true;

/*-------------+
| Constructors |
+-------------*/

	/**
	 * Constructor.
	 *
	 * @param id The ID of the namespace.
	 * @param prefix prefix of namespace
	 * @param name name namespace
	 */	
	public Namespace(int id, String prefix, String name) {
		this(id, prefix, name, false);
	}

	/**
	 * Constructor.
	 *
	 * @param id The ID of the namespace.
	 * @param prefix prefix of namespace
	 * @param name name of namespace
	 * @param export Flag indicating whether the namespace should be export or
	 * that it is purely for internal use
	 */	
	public Namespace(int id, String prefix, String name, boolean export) {
		_id = id;
		_prefix = prefix;
		_name = name;
		_export = export;
	}

/*--------+
| Methods |
+--------*/

	/**
	 * Gets the internal ID of the namespace.
	 **/
	public int getID() {
		return _id;
	}

	/**
	 * Gets the prefix of namespace.
	 */
	public String getPrefix() {
		return _prefix;
	}

	public void setPrefix(String prefix) {
		_prefix = prefix;
	}

	/**
	 * Gets the name of namespace.
	 */
	public String getName() {
		return _name;
	}

	public void setExported(boolean export) {
		_export = export;
	}

	public boolean exported() {
		return _export;
	}
	
	/**
	 * Returns a string representation of the namespace.
	 */
	public String toString() {
		return _prefix + "::" + _name;
	}
}
