/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.model.Statement;
import org.openrdf.model.Value;

/**
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.7.4.2 $
 **/
public interface ValueNode extends Value {

	public StatementList getObjectStatementList();

	/**
	 * Gets the amount of Statements for which this ValueNode is the object.
	 * @return An integer larger than or equal to 0.
	 **/
	public int getObjectStatementCount();

	/**
	 * Adds a statement to this ValueNode's list of statements for which
	 * it is the object.
	 **/
	public void addObjectStatement(Statement st);

	/**
	 * Removes a statement from this ValueNode's list of statements for which
	 * it is the object.
	 **/
	public void removeObjectStatement(Statement st);

	/**
	 * Returns the RdfSource that contains this ValueNode. ValueNodes
	 * are only unique within a single repository, but an application
	 * could use several repository at the same time, passing ValueNodes
	 * generated by one Sail to another Sail. In such situations, the
	 * ValueNode of the first Sail cannot be used by the second Sail.
	 **/
	public RdfSource getRdfSource();
}
