/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.memory;

import java.util.Arrays;

import org.openrdf.model.Statement;

/**
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.3.4.2 $
 **/
public class StatementList {

/*--------------+
| Variables     |
+--------------*/

	private Statement[] _statements;
	private int _size;

/*--------------+
| Constructors  |
+--------------*/

	/**
	 * Creates a new StatementList.
	 **/
	public StatementList() {
		this(4);
	}

	public StatementList(int size) {
		_statements = new Statement[size];
		_size = 0;
	}

	public StatementList(StatementList other) {
		this(other._size);
		addAll(other);
	}

/*-------------+
| Methods      |
+-------------*/

	public int size() {
		return _size;
	}

	public boolean isEmpty() {
		return _size == 0;
	}

	public Statement get(int index) {
		if (index < 0 || index >= _size) {
			if (index < 0) {
				throw new IndexOutOfBoundsException("index < 0");
			} else {
				throw new IndexOutOfBoundsException("index >= size");
			}
		}

		return _statements[index];
	}

	public void add(Statement st) {
		if (_size == _statements.length) {
			// Grow array
			_growArray( (_size==0) ? 1 : 2*_size );
		}

		_statements[_size] = st;
		++_size;
	}

	public void addAll(StatementList other) {
		if (_size + other._size >= _statements.length) {
			// Grow array
			_growArray(_size + other._size);
		}

		System.arraycopy(other._statements, 0, _statements, _size, other._size);
		_size += other._size;
	}

	public void remove(int index) {
		if (index < 0 || index >= _size) {
			if (index < 0) {
				throw new IndexOutOfBoundsException("index < 0");
			} else {
				throw new IndexOutOfBoundsException("index >= size");
			}
		}

		if (index == _size - 1) {
			// Last statement in array
			_statements[index] = null;
			--_size;
		}
		else {
			// Not last statement in array, move last
			// statement over the one at [index]
			--_size;
			_statements[index] = _statements[_size];
			_statements[_size] = null;
		}
	}

	public void remove(Statement st) {
		for (int i = 0; i < _size; ++i) {
			if (_statements[i] == st) {
				remove(i);
				return;
			}
		}
	}

	public void clear() {
		Arrays.fill(_statements, 0, _size, null);
		_size = 0;
	}

	private void _growArray(int size) {
		Statement[] newArray = new Statement[size];
		System.arraycopy(_statements, 0, newArray, 0, _size);
		_statements = newArray;
	}
}
