/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * An extension of ValueNode giving it subject statements.
 *
 * @author Arjohn Kampman
 * @author Jeen Broekstra
 * @version $Revision: 1.9.4.2 $
 **/
public interface ResourceNode extends ValueNode, Resource {

	static final StatementList EMPTY_LIST = new StatementList(0);

	public StatementList getSubjectStatementList();

	/**
	 * Gets the amount of Statements for which this ResourceNode is the subject.
	 * @return An integer larger than or equal to 0.
	 **/
	public int getSubjectStatementCount();

	/**
	 * Adds a statement to this ResourceNode's list of statements for which
	 * it is the subject.
	 **/
	public void addSubjectStatement(Statement st);

	/**
	 * Removes a statement from this ResourceNode's list of statements for which
	 * it is the subject.
	 **/
	public void removeSubjectStatement(Statement st);
	
	public StatementIterator getDirectTypeStatements();
	
	public StatementIterator getDirectSubClassStatements();
	
	public StatementIterator getDirectSubPropertyStatements();

	public boolean isDirectType(Resource aClass);
	
	public boolean isDirectSubClass(Resource aClass);
	
	public boolean isDirectSubProperty(Resource aProperty);
	
	/**
	 * clears all caches for direct type, subclass and subproperty relations.
	 */
	public void clearCache();
}
