/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.memory;

import java.util.Collection;
import java.util.Iterator;

import org.openrdf.model.Resource;
import org.openrdf.model.Value;

import org.openrdf.sesame.sail.ResourceIterator;

/**
 * An implementation of org.openrdf.sesame.sail.ResourceIterator that
 * can iterate over a list of Resource objects. 
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 */
public class MemResourceIterator implements ResourceIterator {
	
/*---------------------------+
| Variables                  |
+---------------------------*/

	private Iterator _iter;
	
/*---------------------------+
| Constructors               |
+---------------------------*/

	public MemResourceIterator(Collection resources) {
		_iter = resources.iterator();
	}
	
/*---------------------------+
| Methods                    |
+---------------------------*/
	
	public boolean hasNext() {
		return _iter != null && _iter.hasNext();
	}

	public Value next() {
		return nextResource();
	}

	public Resource nextResource() {
		return (Resource)_iter.next();
	}

	public void close() {
		_iter = null;
	}
}
