/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sailimpl.memory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.openrdf.sesame.sail.NamespaceIterator;

/**
 * An implementation of org.openrdf.sesame.sail.NamespaceIterator that
 * can iterate over a list of Namespace objects.
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 **/
public class MemNamespaceIterator
	implements NamespaceIterator
{

/*----------------------------------+
| Variables                         |
+----------------------------------*/

	/** The current Namespace. **/
	protected Namespace _namespace;

	/** Iterator over Namespaces. **/
	protected Iterator _iterator;

/*----------------------------------+
| Constructors                      |
+----------------------------------*/

	/**
	 * Constructor.
	 *
	 * @param namespaces List of Namespace objects
	 **/
	public MemNamespaceIterator(List namespaces) {
		// Copy namespace objects to prevent Exception from being thrown
		// because of changes in the namespaces Map:
		ArrayList namespaceList = new ArrayList();
		Iterator it = namespaces.iterator();

		// only put exported namespaces in the iterator
		while (it.hasNext()) {
			Namespace ns = (Namespace)it.next();
			if (ns.exported()) {
				namespaceList.add(ns);
			}
		}
		it = null;
		_iterator = namespaceList.iterator();
	}

/*----------------------------------+
| Methods                           |
+----------------------------------*/

	public boolean hasNext() {
		return _iterator.hasNext();
	}

	public void next() {
		_namespace = (Namespace)_iterator.next();
	}

	public String getPrefix() {
		return _namespace.getPrefix();
	}

	public String getName() {
		return _namespace.getName();
	}

	public void close() {
		_iterator = null;
		_namespace = null;
	}
}
