/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.util;

import java.util.NoSuchElementException;

import org.openrdf.model.Value;

import org.openrdf.sesame.sail.ValueIterator;

/**
 * A ValueIterator that contains exactly one Value.
 * @version $Revision: 1.4.4.2 $
 **/
public class SingleValueIterator implements ValueIterator {

/*-----------------------------------------+
| Variables                                |
+-----------------------------------------*/

	/** The value. **/
	private Value _value;

	private boolean _hasNext = true;

/*-----------------------------------------+
| Constructors                             |
+-----------------------------------------*/

	/**
	 * Creates a new SingleValueIterator that will return the supplied value
	 * as its only value.
	 *
	 * @param value The Value to return.
	 **/
	public SingleValueIterator(Value value) {
		_value = value;
		_hasNext = true;
	}

/*-----------------------------------------+
| Methods                                  |
+-----------------------------------------*/

	public boolean hasNext() {
		return _hasNext;
	}

	public Value next() {
		if (_hasNext) {
			_hasNext = false;
			return _value;
		}
		else {
			throw new NoSuchElementException(
				"A SingleValueIterator contains only one element");
		}
	}

	public void close() {
		_hasNext = false;
	}
}
