/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2004 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sail.util;

import org.openrdf.sesame.sail.SailChangedEvent;

/**
 * Default implementation of the SailChangedEvent interface.
 * 
 * @author Jeen Broekstra
 */
public class SailChangedEventImpl implements SailChangedEvent {

	private boolean _statementsAdded;

	private boolean _statementsRemoved;

	/**
	 * Creates a new SailChangedEventImpl in which all possible changes are set to false.
	 */
	public SailChangedEventImpl() {
		this(false, false);
	}

	/**
	 * Creates a new SailChangedEventImpl in which statementsAdded and statementsRemoved are set 
	 * to the supplied values. 
	 * 
	 * @param statementsAdded indicates if statements were added during this event.
	 * @param statementsRemoved indicates if statements were removed during this event.
	 */
	public SailChangedEventImpl(boolean statementsAdded,
			boolean statementsRemoved)
	{
		_statementsAdded = statementsAdded;
		_statementsRemoved = statementsRemoved;
	}

	public void setStatementsAdded(boolean statementsAdded) {
		_statementsAdded = statementsAdded;
	}

	public void setStatementsRemoved(boolean statementsRemoved) {
		_statementsRemoved = statementsRemoved;
	}

	/**
	 * Utitiliy method that ndicates whether anything has changed in the Sail during this even. NOTE:
	 * this is not meant to be used at the listener-side, it is strictly a convenience method at the 
	 * event-producing side.
	 *  
	 * @return true if the sail has changed, false otherwise. 
	 */
	public boolean sailChanged() {
		return (statementsAdded() || statementsRemoved());
	}

	/* (non-Javadoc)
	 * @see org.openrdf.sesame.sail.SailChangedEvent#statementsAdded()
	 */
	public boolean statementsAdded() {
		return _statementsAdded;
	}

	/* (non-Javadoc)
	 * @see org.openrdf.sesame.sail.SailChangedEvent#statementsRemoved()
	 */
	public boolean statementsRemoved() {
		return _statementsRemoved;
	}

}
