/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.util;

import java.util.Collection;

import org.openrdf.model.Resource;

import org.openrdf.sesame.sail.ResourceIterator;

/**
 * A ResourceIterator that iterates over a Collection of Resource objects.
 * @version $Revision: 1.4.4.2 $
 **/
public class ResourceCollectionIterator
	extends ValueCollectionIterator
	implements ResourceIterator
{

	/**
	 * Creates a new ResourceCollectionIterator that will return all
	 * objects from the supplied Collection.
	 *
	 * @param resources A Collection of Resource objects.
	 **/
	public ResourceCollectionIterator(Collection resources) {
		super(resources);
	}

	public Resource nextResource() {
		return (Resource)next();
	}
}
