/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sail.util;

import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.StackedSail;

/**
 * QuerySailStack - queries the sail stack for a SAIL that is instance of
 * a specific class.i.e. implements a specific interface.
 * @author damyan ognyanoff
 * @version 1.0
 */
public class QuerySailStack {

	/**
	 * Gets the first SAIL from the stacked ones that is instanceof the specified class.
	 * @param base the base SAIL in the stacked SAILs list.
	 * @param classToQuery the class of the interface wanted
	 * @return the first SAIL that is instance of the specified class
	 */
  public static Sail queryInterface( Sail base, String classToQuery)
  {
    Class cls = null;
    try {
      cls = Class.forName(classToQuery);
    } catch (ClassNotFoundException e){
    }
    if (cls != null) {
      if (cls.isInstance(base))
        return base;
      while (base instanceof StackedSail) {
        base = ((StackedSail)base).getBaseSail();
        if (base != null && cls.isInstance(base))
          return base;
      }
    }
    return null;
  }

	/**
	 * Gets the first SAIL from the stacked ones that is instanceof the specified class.
	 * @param base the base SAIL in the stacked SAILs list.
	 * @param classToQuery the class of the interface wanted
	 * @return the first SAIL that is instance of the specified class
	 */
  public static Sail queryInterface( Sail base, Class classToQuery)
  {
    if (classToQuery != null) {
      if (classToQuery.isInstance(base))
        return base;
      while (base instanceof StackedSail) {
        base = ((StackedSail)base).getBaseSail();
        if (base != null && classToQuery.isInstance(base))
          return base;
      }
    }
    return null;
  }
}
