/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.util;

import java.util.NoSuchElementException;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * A StatementIterator that contains exactly zero statements.
 * @version $Revision: 1.4.4.2 $
 **/
public class EmptyStatementIterator implements StatementIterator {

/*-----------------------------------------+
| Constructors                             |
+-----------------------------------------*/

	/**
	 * Creates an EmptyStatementIterator.
	 **/
	public EmptyStatementIterator() {
	}

/*-----------------------------------------+
| Methods                                  |
+-----------------------------------------*/

	/**
	 * Always return false;
	 **/
	public boolean hasNext() {
		return false;
	}

	/**
	 * Always throws a NoSuchElementException as there are no results
	 * in an EmptyStatementIterator.
	 *
	 * @exception NoSuchElementException Is always thrown.
	 **/
	public Statement next() {
		throw new NoSuchElementException(
				"An EmptyStatementIterator does not contain any elements");
	}

	/**
	 * Always returns null.
	 *
	 * @deprecated Replaced by Statement.getSubject().
	 **/
	public Resource getSubject() {
		return null;
	}

	/**
	 * Always returns null.
	 *
	 * @deprecated Replaced by Statement.getPredicate().
	 **/
	public Resource getPredicate() {
		return null;
	}

	/**
	 * Always returns null.
	 *
	 * @deprecated Replaced by Statement.getObject().
	 **/
	public Value getObject() {
		return null;
	}

	public void close() {
	}
}
