/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

/**
 * A variable that can contain a Value.
 *
 * @author Arjohn Kampman
 */
public class Var implements ValueExpr {

/*-------------------------------+
| Variables                      |
+-------------------------------*/

	protected String _name;

	protected Value _value;
	
	private boolean _anonymous = false;

/*-------------------------------+
| Constructors                   |
+-------------------------------*/

	public Var(String name) {
		_name = name;
	}

	public Var(String name, Value value) {
		this(name);
		setValue(value);
	}

/*-------------------------------+
| Methods                        |
+-------------------------------*/

	public void setAnonymous(boolean anonymous) {
		_anonymous = anonymous;
	}
	
	public boolean isAnonymous() {
		return _anonymous;
	}
	
	public String getName() {
		return _name;
	}

	public void setValue(Value value) {
		_value = value;
	}

	public boolean hasValue() {
		return _value != null;
	}

	public Value getValue() {
		return _value;
	}

	public String getString() {
		if (_value instanceof Literal) {
			return ((Literal)_value).getLabel();
		}
		else if (_value instanceof URI) {
			return ((URI)_value).getURI();
		}
		else if (_value instanceof BNode) {
			return ((BNode)_value).getID();
		}
		else {
			return null;
		}
	}

	public void getVariables(Collection variables) {
		variables.add(this);
	}

	public boolean equals(Object other) {
		if (other instanceof Var) {
			return _name.equals( ((Var)other)._name );
		}

		return false;
	}

	public int hashCode() {
		return _name.hashCode();
	}

	public String toString() {
		return _name;
	}
}
