/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 * A comparison between two strings.
 **/
public class StringCompare implements BooleanExpr {

/*----------+
| Constants |
+----------*/

	/** equal to **/
	public static final int EQ = 1;

	/** not equal to **/
	public static final int NE = 2;

/*----------+
| Variables |
+----------*/

	private StringExpr _leftArg;
	private StringExpr _rightArg;
	private int _operator;

/*-------------+
| Constructors |
+-------------*/

	public StringCompare(StringExpr leftArg, StringExpr rightArg) {
		this(leftArg, rightArg, EQ);
	}

	public StringCompare(StringExpr leftArg, StringExpr rightArg, int op) {
		if (op != EQ && op != NE) {
			throw new IllegalArgumentException("Illegal operator value: " + op);
		}

		_leftArg = leftArg;
		_rightArg = rightArg;
		_operator = op;
	}

/*-------------------------+
| Methods                  |
+-------------------------*/

	public StringExpr getLeftArg() {
		return _leftArg;
	}

	public StringExpr getRightArg() {
		return _rightArg;
	}

	public int getOperator() {
		return _operator;
	}

	public boolean isTrue(RdfSource rdfSource)
		throws SailQueryException
	{
		boolean result;
		String leftVal = _leftArg.getString();
		String rightVal = _rightArg.getString();

		if (leftVal == null) {
			result = (rightVal == null);
		}
		else {
			result = leftVal.equals(rightVal);
		}

		if (_operator == NE) {
			result = !result;
		}

		return result;
	}

	public void getVariables(Collection variables) {
		_leftArg.getVariables(variables);
		_rightArg.getVariables(variables);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(32);
		buf.append('(');
		buf.append(_leftArg.toString());
		buf.append( (_operator == EQ) ? " = " : " != " );
		buf.append(_rightArg.toString());
		buf.append(')');

		return buf.toString();
	}
}
