/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import java.util.HashSet;

/**
 * Generic set operator. Concrete set operations are union, intersection, and
 * minus.
 *  
 * @author Jeen Broekstra
 */
public abstract class SetOperator implements Query {

/*----------+
| Variables |
+----------*/

	protected Query _leftArg;
	protected Query _rightArg;
	protected boolean _all;

/*-------------+
| Constructors |
+-------------*/

	public SetOperator(Query leftArg, Query rightArg, boolean all) {
		_leftArg = leftArg;
		_rightArg = rightArg;
		_all = all;
	}

/*--------+
| Methods |
+--------*/

	public Query getLeftArg() {
		return _leftArg;
	}

	public Query getRightArg() {
		return _rightArg;
	}

	public void getVariables(Collection variables) {
		_leftArg.getVariables(variables);
		_rightArg.getVariables(variables);
	}

	public String[] getColumnHeaders() {
		return _leftArg.getColumnHeaders();
	}

	// implements Query._reportQueryAnswer(QueryAnswerListener)
	protected boolean _reportQueryAnswer(QueryAnswerListener listener) {
		return false;
	}

/*---------------------------------+
| Inner class QueryAnswerCollector |
+---------------------------------*/

	protected static class QueryAnswerCollector implements QueryAnswerListener {

		private HashSet _queryAnswers = new HashSet();

		// implements QueryAnswerListener.queryAnswer(QueryAnswer)
		public boolean queryAnswer(QueryAnswer qa) {
			_queryAnswers.add(qa);
			return true;
		}

		// implements QueryAnswerListener.clear()
		public void clear() {
			_queryAnswers.clear();
		}

		/**
		 * Returns the accumulated query answers.
		 **/
		public HashSet getQueryAnswers() {
			return _queryAnswers;
		}
	}
}
