/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.io.IOException;

/**
 * A QueryAnswerListener that counts the number of reported query results
 * and forwards them to another QueryAnswerListener.
 **/
public class QueryResultsCounter implements QueryAnswerListener {

/*----------+
| Variables |
+----------*/

	/**
	 * The number of query results that have been reported so far.
	 **/
	private int _count;

	/**
	 * The listener to forward any query results to.
	 **/
	private QueryAnswerListener _listener;

/*-------------+
| Constructors |
+-------------*/

	/**
	 * Creates a new QueryResultsCounter.
	 **/
	public QueryResultsCounter() {
	}

	/**
	 * Creates a new QueryResultsCounter that forwards any query results to the
	 * specified listener.
	 *
	 * @param l A QueryAnswerListener.
	 **/
	public QueryResultsCounter(QueryAnswerListener l) {
		_listener = l;
	}

/*--------+
| Methods |
+--------*/

	// implements QueryAnswerListener.queryAnswer(QueryAnswer)
	public boolean queryAnswer(QueryAnswer qa)
		throws IOException
	{
		_count++;

		if (_listener != null) {
			return _listener.queryAnswer(qa);
		}

		return true;
	}

	// implements QueryAnswerListener.clear()
	public void clear() {
		if (_listener != null) {
			_listener.clear();
		}
	}

	/**
	 * Gets the number of query answers that has been counted.
	 **/
	public int getCount() {
		return _count;
	}

	/**
	 * Resets the counter to 0.
	 **/
	public void resetCounter() {
		_count = 0;
	}
}
